package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ValueSetId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueSetToListOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueSetToListOperator.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableValueSetToListOperator.of()}.
 */
@Generated(from = "ValueSetToListOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableValueSetToListOperator
    implements ValueSetToListOperator {
  private final ValueSetId valueSetId;

  private ImmutableValueSetToListOperator(ValueSetId valueSetId) {
    this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
  }

  private ImmutableValueSetToListOperator(
      ImmutableValueSetToListOperator original,
      ValueSetId valueSetId) {
    this.valueSetId = valueSetId;
  }

  /**
   * @return The value of the {@code valueSetId} attribute
   */
  @Override
  public ValueSetId getValueSetId() {
    return valueSetId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueSetToListOperator#getValueSetId() valueSetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueSetId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableValueSetToListOperator withValueSetId(ValueSetId value) {
    if (this.valueSetId == value) return this;
    ValueSetId newValue = Objects.requireNonNull(value, "valueSetId");
    return new ImmutableValueSetToListOperator(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueSetToListOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValueSetToListOperator
        && equalsByValue((ImmutableValueSetToListOperator) another);
  }

  private boolean equalsByValue(ImmutableValueSetToListOperator another) {
    return valueSetId.equals(another.valueSetId);
  }

  /**
   * Computes a hash code from attributes: {@code valueSetId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + valueSetId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueSetToListOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValueSetToListOperator")
        .omitNullValues()
        .add("valueSetId", valueSetId)
        .toString();
  }

  /**
   * Construct a new immutable {@code ValueSetToListOperator} instance.
   * @param valueSetId The value for the {@code valueSetId} attribute
   * @return An immutable ValueSetToListOperator instance
   */
  public static ImmutableValueSetToListOperator of(ValueSetId valueSetId) {
    return new ImmutableValueSetToListOperator(valueSetId);
  }

  /**
   * Creates an immutable copy of a {@link ValueSetToListOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValueSetToListOperator instance
   */
  public static ImmutableValueSetToListOperator copyOf(ValueSetToListOperator instance) {
    if (instance instanceof ImmutableValueSetToListOperator) {
      return (ImmutableValueSetToListOperator) instance;
    }
    return ImmutableValueSetToListOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueSetToListOperator ImmutableValueSetToListOperator}.
   * <pre>
   * ImmutableValueSetToListOperator.builder()
   *    .valueSetId(io.dialob.session.engine.session.model.ValueSetId) // required {@link ValueSetToListOperator#getValueSetId() valueSetId}
   *    .build();
   * </pre>
   * @return A new ImmutableValueSetToListOperator builder
   */
  public static ImmutableValueSetToListOperator.Builder builder() {
    return new ImmutableValueSetToListOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValueSetToListOperator ImmutableValueSetToListOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueSetToListOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE_SET_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ValueSetId valueSetId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValueSetToListOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValueSetToListOperator instance) {
      Objects.requireNonNull(instance, "instance");
      this.valueSetId(instance.getValueSetId());
      return this;
    }

    /**
     * Initializes the value for the {@link ValueSetToListOperator#getValueSetId() valueSetId} attribute.
     * @param valueSetId The value for valueSetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueSetId(ValueSetId valueSetId) {
      this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
      initBits &= ~INIT_BIT_VALUE_SET_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueSetToListOperator ImmutableValueSetToListOperator}.
     * @return An immutable instance of ValueSetToListOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueSetToListOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValueSetToListOperator(null, valueSetId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE_SET_ID) != 0) attributes.add("valueSetId");
      return "Cannot build ValueSetToListOperator, some of required attributes are not set " + attributes;
    }
  }
}
