package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ValueSetId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueSetEntryToStringOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueSetEntryToStringOperator.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableValueSetEntryToStringOperator.of()}.
 */
@Generated(from = "ValueSetEntryToStringOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableValueSetEntryToStringOperator
    implements ValueSetEntryToStringOperator {
  private final ValueSetId valueSetId;
  private final Expression expression;

  private ImmutableValueSetEntryToStringOperator(
      ValueSetId valueSetId,
      Expression expression) {
    this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
    this.expression = Objects.requireNonNull(expression, "expression");
  }

  private ImmutableValueSetEntryToStringOperator(
      ImmutableValueSetEntryToStringOperator original,
      ValueSetId valueSetId,
      Expression expression) {
    this.valueSetId = valueSetId;
    this.expression = expression;
  }

  /**
   * @return The value of the {@code valueSetId} attribute
   */
  @Override
  public ValueSetId getValueSetId() {
    return valueSetId;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @Override
  public Expression getExpression() {
    return expression;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueSetEntryToStringOperator#getValueSetId() valueSetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueSetId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableValueSetEntryToStringOperator withValueSetId(ValueSetId value) {
    if (this.valueSetId == value) return this;
    ValueSetId newValue = Objects.requireNonNull(value, "valueSetId");
    return new ImmutableValueSetEntryToStringOperator(this, newValue, this.expression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueSetEntryToStringOperator#getExpression() expression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableValueSetEntryToStringOperator withExpression(Expression value) {
    if (this.expression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "expression");
    return new ImmutableValueSetEntryToStringOperator(this, this.valueSetId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueSetEntryToStringOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValueSetEntryToStringOperator
        && equalsByValue((ImmutableValueSetEntryToStringOperator) another);
  }

  private boolean equalsByValue(ImmutableValueSetEntryToStringOperator another) {
    return valueSetId.equals(another.valueSetId)
        && expression.equals(another.expression);
  }

  /**
   * Computes a hash code from attributes: {@code valueSetId}, {@code expression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + valueSetId.hashCode();
    h += (h << 5) + expression.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueSetEntryToStringOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValueSetEntryToStringOperator")
        .omitNullValues()
        .add("valueSetId", valueSetId)
        .add("expression", expression)
        .toString();
  }

  /**
   * Construct a new immutable {@code ValueSetEntryToStringOperator} instance.
   * @param valueSetId The value for the {@code valueSetId} attribute
   * @param expression The value for the {@code expression} attribute
   * @return An immutable ValueSetEntryToStringOperator instance
   */
  public static ImmutableValueSetEntryToStringOperator of(ValueSetId valueSetId, Expression expression) {
    return new ImmutableValueSetEntryToStringOperator(valueSetId, expression);
  }

  /**
   * Creates an immutable copy of a {@link ValueSetEntryToStringOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValueSetEntryToStringOperator instance
   */
  public static ImmutableValueSetEntryToStringOperator copyOf(ValueSetEntryToStringOperator instance) {
    if (instance instanceof ImmutableValueSetEntryToStringOperator) {
      return (ImmutableValueSetEntryToStringOperator) instance;
    }
    return ImmutableValueSetEntryToStringOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueSetEntryToStringOperator ImmutableValueSetEntryToStringOperator}.
   * <pre>
   * ImmutableValueSetEntryToStringOperator.builder()
   *    .valueSetId(io.dialob.session.engine.session.model.ValueSetId) // required {@link ValueSetEntryToStringOperator#getValueSetId() valueSetId}
   *    .expression(io.dialob.session.engine.program.model.Expression) // required {@link ValueSetEntryToStringOperator#getExpression() expression}
   *    .build();
   * </pre>
   * @return A new ImmutableValueSetEntryToStringOperator builder
   */
  public static ImmutableValueSetEntryToStringOperator.Builder builder() {
    return new ImmutableValueSetEntryToStringOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValueSetEntryToStringOperator ImmutableValueSetEntryToStringOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueSetEntryToStringOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE_SET_ID = 0x1L;
    private static final long INIT_BIT_EXPRESSION = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ValueSetId valueSetId;
    private @Nullable Expression expression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValueSetEntryToStringOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValueSetEntryToStringOperator instance) {
      Objects.requireNonNull(instance, "instance");
      this.valueSetId(instance.getValueSetId());
      this.expression(instance.getExpression());
      return this;
    }

    /**
     * Initializes the value for the {@link ValueSetEntryToStringOperator#getValueSetId() valueSetId} attribute.
     * @param valueSetId The value for valueSetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueSetId(ValueSetId valueSetId) {
      this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
      initBits &= ~INIT_BIT_VALUE_SET_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueSetEntryToStringOperator#getExpression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expression(Expression expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueSetEntryToStringOperator ImmutableValueSetEntryToStringOperator}.
     * @return An immutable instance of ValueSetEntryToStringOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueSetEntryToStringOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValueSetEntryToStringOperator(null, valueSetId, expression);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE_SET_ID) != 0) attributes.add("valueSetId");
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      return "Cannot build ValueSetEntryToStringOperator, some of required attributes are not set " + attributes;
    }
  }
}
