package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RowItemsExpression}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRowItemsExpression.builder()}.
 */
@Generated(from = "RowItemsExpression", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRowItemsExpression
    implements RowItemsExpression {
  private final ImmutableList<ItemId> itemIds;

  private ImmutableRowItemsExpression(ImmutableList<ItemId> itemIds) {
    this.itemIds = itemIds;
  }

  /**
   * @return The value of the {@code itemIds} attribute
   */
  @Override
  public ImmutableList<ItemId> getItemIds() {
    return itemIds;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RowItemsExpression#getItemIds() itemIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRowItemsExpression withItemIds(ItemId... elements) {
    ImmutableList<ItemId> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRowItemsExpression(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RowItemsExpression#getItemIds() itemIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of itemIds elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableRowItemsExpression withItemIds(Iterable<? extends ItemId> elements) {
    if (this.itemIds == elements) return this;
    ImmutableList<ItemId> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRowItemsExpression(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRowItemsExpression} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRowItemsExpression
        && equalsByValue((ImmutableRowItemsExpression) another);
  }

  private boolean equalsByValue(ImmutableRowItemsExpression another) {
    return itemIds.equals(another.itemIds);
  }

  /**
   * Computes a hash code from attributes: {@code itemIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + itemIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RowItemsExpression} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RowItemsExpression")
        .omitNullValues()
        .add("itemIds", itemIds)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link RowItemsExpression} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RowItemsExpression instance
   */
  public static ImmutableRowItemsExpression copyOf(RowItemsExpression instance) {
    if (instance instanceof ImmutableRowItemsExpression) {
      return (ImmutableRowItemsExpression) instance;
    }
    return ImmutableRowItemsExpression.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRowItemsExpression ImmutableRowItemsExpression}.
   * <pre>
   * ImmutableRowItemsExpression.builder()
   *    .addItemIds|addAllItemIds(io.dialob.session.engine.session.model.ItemId) // {@link RowItemsExpression#getItemIds() itemIds} elements
   *    .build();
   * </pre>
   * @return A new ImmutableRowItemsExpression builder
   */
  public static ImmutableRowItemsExpression.Builder builder() {
    return new ImmutableRowItemsExpression.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRowItemsExpression ImmutableRowItemsExpression}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RowItemsExpression", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<ItemId> itemIds = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RowItemsExpression} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RowItemsExpression instance) {
      Objects.requireNonNull(instance, "instance");
      addAllItemIds(instance.getItemIds());
      return this;
    }

    /**
     * Adds one element to {@link RowItemsExpression#getItemIds() itemIds} list.
     * @param element A itemIds element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItemIds(ItemId element) {
      this.itemIds.add(element);
      return this;
    }

    /**
     * Adds elements to {@link RowItemsExpression#getItemIds() itemIds} list.
     * @param elements An array of itemIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItemIds(ItemId... elements) {
      this.itemIds.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RowItemsExpression#getItemIds() itemIds} list.
     * @param elements An iterable of itemIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder itemIds(Iterable<? extends ItemId> elements) {
      this.itemIds = ImmutableList.builder();
      return addAllItemIds(elements);
    }

    /**
     * Adds elements to {@link RowItemsExpression#getItemIds() itemIds} list.
     * @param elements An iterable of itemIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllItemIds(Iterable<? extends ItemId> elements) {
      this.itemIds.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRowItemsExpression ImmutableRowItemsExpression}.
     * @return An immutable instance of RowItemsExpression
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRowItemsExpression build() {
      return new ImmutableRowItemsExpression(itemIds.build());
    }
  }
}
