package io.dialob.session.engine.program.expr.arith;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NowExpression}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNowExpression.builder()}.
 */
@Generated(from = "NowExpression", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNowExpression implements NowExpression {

  private ImmutableNowExpression(ImmutableNowExpression.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNowExpression} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNowExpression
        && equalsByValue((ImmutableNowExpression) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalsByValue(ImmutableNowExpression another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -142810355;
  }

  /**
   * Prints the immutable value {@code NowExpression}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NowExpression{}";
  }

  /**
   * Creates an immutable copy of a {@link NowExpression} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NowExpression instance
   */
  public static ImmutableNowExpression copyOf(NowExpression instance) {
    if (instance instanceof ImmutableNowExpression) {
      return (ImmutableNowExpression) instance;
    }
    return ImmutableNowExpression.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNowExpression ImmutableNowExpression}.
   * <pre>
   * ImmutableNowExpression.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableNowExpression builder
   */
  public static ImmutableNowExpression.Builder builder() {
    return new ImmutableNowExpression.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNowExpression ImmutableNowExpression}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NowExpression", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NowExpression} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NowExpression instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableNowExpression ImmutableNowExpression}.
     * @return An immutable instance of NowExpression
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNowExpression build() {
      return new ImmutableNowExpression(this);
    }
  }
}
