package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NegOperatorDecimal}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNegOperatorDecimal.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNegOperatorDecimal.of()}.
 */
@Generated(from = "NegOperatorDecimal", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNegOperatorDecimal
    implements NegOperatorDecimal {
  private final Expression expression;

  private ImmutableNegOperatorDecimal(Expression expression) {
    this.expression = Objects.requireNonNull(expression, "expression");
  }

  private ImmutableNegOperatorDecimal(ImmutableNegOperatorDecimal original, Expression expression) {
    this.expression = expression;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @Override
  public Expression getExpression() {
    return expression;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NegOperatorDecimal#getExpression() expression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableNegOperatorDecimal withExpression(Expression value) {
    if (this.expression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "expression");
    return new ImmutableNegOperatorDecimal(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNegOperatorDecimal} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNegOperatorDecimal
        && equalsByValue((ImmutableNegOperatorDecimal) another);
  }

  private boolean equalsByValue(ImmutableNegOperatorDecimal another) {
    return expression.equals(another.expression);
  }

  /**
   * Computes a hash code from attributes: {@code expression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + expression.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NegOperatorDecimal} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NegOperatorDecimal")
        .omitNullValues()
        .add("expression", expression)
        .toString();
  }

  /**
   * Construct a new immutable {@code NegOperatorDecimal} instance.
   * @param expression The value for the {@code expression} attribute
   * @return An immutable NegOperatorDecimal instance
   */
  public static ImmutableNegOperatorDecimal of(Expression expression) {
    return new ImmutableNegOperatorDecimal(expression);
  }

  /**
   * Creates an immutable copy of a {@link NegOperatorDecimal} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NegOperatorDecimal instance
   */
  public static ImmutableNegOperatorDecimal copyOf(NegOperatorDecimal instance) {
    if (instance instanceof ImmutableNegOperatorDecimal) {
      return (ImmutableNegOperatorDecimal) instance;
    }
    return ImmutableNegOperatorDecimal.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNegOperatorDecimal ImmutableNegOperatorDecimal}.
   * <pre>
   * ImmutableNegOperatorDecimal.builder()
   *    .expression(io.dialob.session.engine.program.model.Expression) // required {@link NegOperatorDecimal#getExpression() expression}
   *    .build();
   * </pre>
   * @return A new ImmutableNegOperatorDecimal builder
   */
  public static ImmutableNegOperatorDecimal.Builder builder() {
    return new ImmutableNegOperatorDecimal.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNegOperatorDecimal ImmutableNegOperatorDecimal}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NegOperatorDecimal", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXPRESSION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Expression expression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.expr.arith.NegOperatorDecimal} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NegOperatorDecimal instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.expr.arith.UnaryOperator} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UnaryOperator instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.expr.arith.NegOperator} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NegOperator instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      @Var long bits = 0;
      if (object instanceof NegOperatorDecimal) {
        NegOperatorDecimal instance = (NegOperatorDecimal) object;
        if ((bits & 0x1L) == 0) {
          this.expression(instance.getExpression());
          bits |= 0x1L;
        }
      }
      if (object instanceof UnaryOperator) {
        UnaryOperator instance = (UnaryOperator) object;
        if ((bits & 0x1L) == 0) {
          this.expression(instance.getExpression());
          bits |= 0x1L;
        }
      }
      if (object instanceof NegOperator) {
        NegOperator instance = (NegOperator) object;
        if ((bits & 0x1L) == 0) {
          this.expression(instance.getExpression());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link NegOperatorDecimal#getExpression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expression(Expression expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNegOperatorDecimal ImmutableNegOperatorDecimal}.
     * @return An immutable instance of NegOperatorDecimal
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNegOperatorDecimal build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNegOperatorDecimal(null, expression);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      return "Cannot build NegOperatorDecimal, some of required attributes are not set " + attributes;
    }
  }
}
