package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.model.Expression;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LocalizedLabelOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLocalizedLabelOperator.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableLocalizedLabelOperator.of()}.
 */
@Generated(from = "LocalizedLabelOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLocalizedLabelOperator
    implements LocalizedLabelOperator {
  private final ImmutableMap<String, Expression> value;

  private ImmutableLocalizedLabelOperator(Map<String, ? extends Expression> value) {
    this.value = ImmutableMap.copyOf(value);
  }

  private ImmutableLocalizedLabelOperator(
      ImmutableLocalizedLabelOperator original,
      ImmutableMap<String, Expression> value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public ImmutableMap<String, Expression> getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by replacing the {@link LocalizedLabelOperator#getValue() value} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the value map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableLocalizedLabelOperator withValue(Map<String, ? extends Expression> entries) {
    if (this.value == entries) return this;
    ImmutableMap<String, Expression> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableLocalizedLabelOperator(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLocalizedLabelOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLocalizedLabelOperator
        && equalsByValue((ImmutableLocalizedLabelOperator) another);
  }

  private boolean equalsByValue(ImmutableLocalizedLabelOperator another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LocalizedLabelOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LocalizedLabelOperator")
        .omitNullValues()
        .add("value", value)
        .toString();
  }

  /**
   * Construct a new immutable {@code LocalizedLabelOperator} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable LocalizedLabelOperator instance
   */
  public static ImmutableLocalizedLabelOperator of(Map<String, ? extends Expression> value) {
    return new ImmutableLocalizedLabelOperator(value);
  }

  /**
   * Creates an immutable copy of a {@link LocalizedLabelOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LocalizedLabelOperator instance
   */
  public static ImmutableLocalizedLabelOperator copyOf(LocalizedLabelOperator instance) {
    if (instance instanceof ImmutableLocalizedLabelOperator) {
      return (ImmutableLocalizedLabelOperator) instance;
    }
    return ImmutableLocalizedLabelOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLocalizedLabelOperator ImmutableLocalizedLabelOperator}.
   * <pre>
   * ImmutableLocalizedLabelOperator.builder()
   *    .putValue|putAllValue(String =&gt; io.dialob.session.engine.program.model.Expression) // {@link LocalizedLabelOperator#getValue() value} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableLocalizedLabelOperator builder
   */
  public static ImmutableLocalizedLabelOperator.Builder builder() {
    return new ImmutableLocalizedLabelOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLocalizedLabelOperator ImmutableLocalizedLabelOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LocalizedLabelOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableMap.Builder<String, Expression> value = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LocalizedLabelOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LocalizedLabelOperator instance) {
      Objects.requireNonNull(instance, "instance");
      putAllValue(instance.getValue());
      return this;
    }

    /**
     * Put one entry to the {@link LocalizedLabelOperator#getValue() value} map.
     * @param key The key in the value map
     * @param value The associated value in the value map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putValue(String key, Expression value) {
      this.value.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link LocalizedLabelOperator#getValue() value} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putValue(Map.Entry<String, ? extends Expression> entry) {
      this.value.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link LocalizedLabelOperator#getValue() value} map. Nulls are not permitted
     * @param entries The entries that will be added to the value map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(Map<String, ? extends Expression> entries) {
      this.value = ImmutableMap.builder();
      return putAllValue(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link LocalizedLabelOperator#getValue() value} map. Nulls are not permitted
     * @param entries The entries that will be added to the value map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllValue(Map<String, ? extends Expression> entries) {
      this.value.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableLocalizedLabelOperator ImmutableLocalizedLabelOperator}.
     * @return An immutable instance of LocalizedLabelOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLocalizedLabelOperator build() {
      return new ImmutableLocalizedLabelOperator(null, value.build());
    }
  }
}
