package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IsRequiredOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIsRequiredOperator.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableIsRequiredOperator.of()}.
 */
@Generated(from = "IsRequiredOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableIsRequiredOperator
    implements IsRequiredOperator {
  private final ItemId itemId;

  private ImmutableIsRequiredOperator(ItemId itemId) {
    this.itemId = Objects.requireNonNull(itemId, "itemId");
  }

  private ImmutableIsRequiredOperator(ImmutableIsRequiredOperator original, ItemId itemId) {
    this.itemId = itemId;
  }

  /**
   * @return The value of the {@code itemId} attribute
   */
  @Override
  public ItemId getItemId() {
    return itemId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IsRequiredOperator#getItemId() itemId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for itemId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableIsRequiredOperator withItemId(ItemId value) {
    if (this.itemId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "itemId");
    return new ImmutableIsRequiredOperator(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIsRequiredOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIsRequiredOperator
        && equalsByValue((ImmutableIsRequiredOperator) another);
  }

  private boolean equalsByValue(ImmutableIsRequiredOperator another) {
    return itemId.equals(another.itemId);
  }

  /**
   * Computes a hash code from attributes: {@code itemId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + itemId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IsRequiredOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IsRequiredOperator")
        .omitNullValues()
        .add("itemId", itemId)
        .toString();
  }

  /**
   * Construct a new immutable {@code IsRequiredOperator} instance.
   * @param itemId The value for the {@code itemId} attribute
   * @return An immutable IsRequiredOperator instance
   */
  public static ImmutableIsRequiredOperator of(ItemId itemId) {
    return new ImmutableIsRequiredOperator(itemId);
  }

  /**
   * Creates an immutable copy of a {@link IsRequiredOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IsRequiredOperator instance
   */
  public static ImmutableIsRequiredOperator copyOf(IsRequiredOperator instance) {
    if (instance instanceof ImmutableIsRequiredOperator) {
      return (ImmutableIsRequiredOperator) instance;
    }
    return ImmutableIsRequiredOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIsRequiredOperator ImmutableIsRequiredOperator}.
   * <pre>
   * ImmutableIsRequiredOperator.builder()
   *    .itemId(io.dialob.session.engine.session.model.ItemId) // required {@link IsRequiredOperator#getItemId() itemId}
   *    .build();
   * </pre>
   * @return A new ImmutableIsRequiredOperator builder
   */
  public static ImmutableIsRequiredOperator.Builder builder() {
    return new ImmutableIsRequiredOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIsRequiredOperator ImmutableIsRequiredOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IsRequiredOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ITEM_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ItemId itemId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code IsRequiredOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(IsRequiredOperator instance) {
      Objects.requireNonNull(instance, "instance");
      this.itemId(instance.getItemId());
      return this;
    }

    /**
     * Initializes the value for the {@link IsRequiredOperator#getItemId() itemId} attribute.
     * @param itemId The value for itemId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder itemId(ItemId itemId) {
      this.itemId = Objects.requireNonNull(itemId, "itemId");
      initBits &= ~INIT_BIT_ITEM_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIsRequiredOperator ImmutableIsRequiredOperator}.
     * @return An immutable instance of IsRequiredOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIsRequiredOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableIsRequiredOperator(null, itemId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ITEM_ID) != 0) attributes.add("itemId");
      return "Cannot build IsRequiredOperator, some of required attributes are not set " + attributes;
    }
  }
}
