package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IsInvalidAnswersOnActivePage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIsInvalidAnswersOnActivePage.builder()}.
 */
@Generated(from = "IsInvalidAnswersOnActivePage", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableIsInvalidAnswersOnActivePage
    implements IsInvalidAnswersOnActivePage {
  private final ItemId pageContainerId;

  private ImmutableIsInvalidAnswersOnActivePage(ItemId pageContainerId) {
    this.pageContainerId = pageContainerId;
  }

  /**
   * @return The value of the {@code pageContainerId} attribute
   */
  @Override
  public ItemId getPageContainerId() {
    return pageContainerId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IsInvalidAnswersOnActivePage#getPageContainerId() pageContainerId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pageContainerId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableIsInvalidAnswersOnActivePage withPageContainerId(ItemId value) {
    if (this.pageContainerId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "pageContainerId");
    return new ImmutableIsInvalidAnswersOnActivePage(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIsInvalidAnswersOnActivePage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIsInvalidAnswersOnActivePage
        && equalsByValue((ImmutableIsInvalidAnswersOnActivePage) another);
  }

  private boolean equalsByValue(ImmutableIsInvalidAnswersOnActivePage another) {
    return pageContainerId.equals(another.pageContainerId);
  }

  /**
   * Computes a hash code from attributes: {@code pageContainerId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + pageContainerId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IsInvalidAnswersOnActivePage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IsInvalidAnswersOnActivePage")
        .omitNullValues()
        .add("pageContainerId", pageContainerId)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link IsInvalidAnswersOnActivePage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IsInvalidAnswersOnActivePage instance
   */
  public static ImmutableIsInvalidAnswersOnActivePage copyOf(IsInvalidAnswersOnActivePage instance) {
    if (instance instanceof ImmutableIsInvalidAnswersOnActivePage) {
      return (ImmutableIsInvalidAnswersOnActivePage) instance;
    }
    return ImmutableIsInvalidAnswersOnActivePage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIsInvalidAnswersOnActivePage ImmutableIsInvalidAnswersOnActivePage}.
   * <pre>
   * ImmutableIsInvalidAnswersOnActivePage.builder()
   *    .pageContainerId(io.dialob.session.engine.session.model.ItemId) // required {@link IsInvalidAnswersOnActivePage#getPageContainerId() pageContainerId}
   *    .build();
   * </pre>
   * @return A new ImmutableIsInvalidAnswersOnActivePage builder
   */
  public static ImmutableIsInvalidAnswersOnActivePage.Builder builder() {
    return new ImmutableIsInvalidAnswersOnActivePage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIsInvalidAnswersOnActivePage ImmutableIsInvalidAnswersOnActivePage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IsInvalidAnswersOnActivePage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PAGE_CONTAINER_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ItemId pageContainerId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code IsInvalidAnswersOnActivePage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(IsInvalidAnswersOnActivePage instance) {
      Objects.requireNonNull(instance, "instance");
      this.pageContainerId(instance.getPageContainerId());
      return this;
    }

    /**
     * Initializes the value for the {@link IsInvalidAnswersOnActivePage#getPageContainerId() pageContainerId} attribute.
     * @param pageContainerId The value for pageContainerId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pageContainerId(ItemId pageContainerId) {
      this.pageContainerId = Objects.requireNonNull(pageContainerId, "pageContainerId");
      initBits &= ~INIT_BIT_PAGE_CONTAINER_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIsInvalidAnswersOnActivePage ImmutableIsInvalidAnswersOnActivePage}.
     * @return An immutable instance of IsInvalidAnswersOnActivePage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIsInvalidAnswersOnActivePage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableIsInvalidAnswersOnActivePage(pageContainerId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PAGE_CONTAINER_ID) != 0) attributes.add("pageContainerId");
      return "Cannot build IsInvalidAnswersOnActivePage, some of required attributes are not set " + attributes;
    }
  }
}
