package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FormatOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormatOperator.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableFormatOperator.of()}.
 */
@Generated(from = "FormatOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormatOperator
    implements FormatOperator {
  private final Expression expression;
  private final String format;

  private ImmutableFormatOperator(Expression expression, String format) {
    this.expression = Objects.requireNonNull(expression, "expression");
    this.format = Objects.requireNonNull(format, "format");
  }

  private ImmutableFormatOperator(
      ImmutableFormatOperator original,
      Expression expression,
      String format) {
    this.expression = expression;
    this.format = format;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @Override
  public Expression getExpression() {
    return expression;
  }

  /**
   * @return The value of the {@code format} attribute
   */
  @Override
  public String getFormat() {
    return format;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormatOperator#getExpression() expression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableFormatOperator withExpression(Expression value) {
    if (this.expression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "expression");
    return new ImmutableFormatOperator(this, newValue, this.format);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormatOperator#getFormat() format} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for format
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableFormatOperator withFormat(String value) {
    String newValue = Objects.requireNonNull(value, "format");
    if (this.format.equals(newValue)) return this;
    return new ImmutableFormatOperator(this, this.expression, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormatOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormatOperator
        && equalsByValue((ImmutableFormatOperator) another);
  }

  private boolean equalsByValue(ImmutableFormatOperator another) {
    return expression.equals(another.expression)
        && format.equals(another.format);
  }

  /**
   * Computes a hash code from attributes: {@code expression}, {@code format}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + expression.hashCode();
    h += (h << 5) + format.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormatOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FormatOperator")
        .omitNullValues()
        .add("expression", expression)
        .add("format", format)
        .toString();
  }

  /**
   * Construct a new immutable {@code FormatOperator} instance.
   * @param expression The value for the {@code expression} attribute
   * @param format The value for the {@code format} attribute
   * @return An immutable FormatOperator instance
   */
  public static ImmutableFormatOperator of(Expression expression, String format) {
    return new ImmutableFormatOperator(expression, format);
  }

  /**
   * Creates an immutable copy of a {@link FormatOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormatOperator instance
   */
  public static ImmutableFormatOperator copyOf(FormatOperator instance) {
    if (instance instanceof ImmutableFormatOperator) {
      return (ImmutableFormatOperator) instance;
    }
    return ImmutableFormatOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormatOperator ImmutableFormatOperator}.
   * <pre>
   * ImmutableFormatOperator.builder()
   *    .expression(io.dialob.session.engine.program.model.Expression) // required {@link FormatOperator#getExpression() expression}
   *    .format(String) // required {@link FormatOperator#getFormat() format}
   *    .build();
   * </pre>
   * @return A new ImmutableFormatOperator builder
   */
  public static ImmutableFormatOperator.Builder builder() {
    return new ImmutableFormatOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormatOperator ImmutableFormatOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FormatOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXPRESSION = 0x1L;
    private static final long INIT_BIT_FORMAT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Expression expression;
    private @Nullable String format;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FormatOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FormatOperator instance) {
      Objects.requireNonNull(instance, "instance");
      this.expression(instance.getExpression());
      this.format(instance.getFormat());
      return this;
    }

    /**
     * Initializes the value for the {@link FormatOperator#getExpression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expression(Expression expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Initializes the value for the {@link FormatOperator#getFormat() format} attribute.
     * @param format The value for format 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder format(String format) {
      this.format = Objects.requireNonNull(format, "format");
      initBits &= ~INIT_BIT_FORMAT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormatOperator ImmutableFormatOperator}.
     * @return An immutable instance of FormatOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormatOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormatOperator(null, expression, format);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      if ((initBits & INIT_BIT_FORMAT) != 0) attributes.add("format");
      return "Cannot build FormatOperator, some of required attributes are not set " + attributes;
    }
  }
}
