package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.model.Expression;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ConditionalListOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConditionalListOperator.builder()}.
 */
@Generated(from = "ConditionalListOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConditionalListOperator<T>
    implements ConditionalListOperator<T> {
  private final ImmutableList<Pair<Expression, T>> items;

  private ImmutableConditionalListOperator(
      ImmutableList<Pair<Expression, T>> items) {
    this.items = items;
  }

  /**
   * @return The value of the {@code items} attribute
   */
  @Override
  public ImmutableList<Pair<Expression, T>> getItems() {
    return items;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConditionalListOperator#getItems() items}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableConditionalListOperator<T> withItems(Pair<Expression, T>... elements) {
    ImmutableList<Pair<Expression, T>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConditionalListOperator<>(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConditionalListOperator#getItems() items}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of items elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableConditionalListOperator<T> withItems(Iterable<? extends Pair<Expression, T>> elements) {
    if (this.items == elements) return this;
    ImmutableList<Pair<Expression, T>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConditionalListOperator<>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConditionalListOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConditionalListOperator<?>
        && equalsByValue((ImmutableConditionalListOperator<?>) another);
  }

  private boolean equalsByValue(ImmutableConditionalListOperator<?> another) {
    return items.equals(another.items);
  }

  /**
   * Computes a hash code from attributes: {@code items}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + items.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConditionalListOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ConditionalListOperator")
        .omitNullValues()
        .add("items", items)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ConditionalListOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ConditionalListOperator instance
   */
  public static <T> ImmutableConditionalListOperator<T> copyOf(ConditionalListOperator<T> instance) {
    if (instance instanceof ImmutableConditionalListOperator<?>) {
      return (ImmutableConditionalListOperator<T>) instance;
    }
    return ImmutableConditionalListOperator.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConditionalListOperator ImmutableConditionalListOperator}.
   * <pre>
   * ImmutableConditionalListOperator.&lt;T&gt;builder()
   *    .addItems|addAllItems(io.dialob.session.engine.program.expr.arith.Pair&lt;io.dialob.session.engine.program.model.Expression, T&gt;) // {@link ConditionalListOperator#getItems() items} elements
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableConditionalListOperator builder
   */
  public static <T> ImmutableConditionalListOperator.Builder<T> builder() {
    return new ImmutableConditionalListOperator.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableConditionalListOperator ImmutableConditionalListOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConditionalListOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private ImmutableList.Builder<Pair<Expression, T>> items = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConditionalListOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(ConditionalListOperator<T> instance) {
      Objects.requireNonNull(instance, "instance");
      addAllItems(instance.getItems());
      return this;
    }

    /**
     * Adds one element to {@link ConditionalListOperator#getItems() items} list.
     * @param element A items element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addItems(Pair<Expression, T> element) {
      this.items.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ConditionalListOperator#getItems() items} list.
     * @param elements An array of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<T> addItems(Pair<Expression, T>... elements) {
      this.items.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ConditionalListOperator#getItems() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> items(Iterable<? extends Pair<Expression, T>> elements) {
      this.items = ImmutableList.builder();
      return addAllItems(elements);
    }

    /**
     * Adds elements to {@link ConditionalListOperator#getItems() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addAllItems(Iterable<? extends Pair<Expression, T>> elements) {
      this.items.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableConditionalListOperator ImmutableConditionalListOperator}.
     * @return An immutable instance of ConditionalListOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConditionalListOperator<T> build() {
      return new ImmutableConditionalListOperator<>(items.build());
    }
  }
}
