package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CollectRowFieldsOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCollectRowFieldsOperator.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableCollectRowFieldsOperator.of()}.
 */
@Generated(from = "CollectRowFieldsOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCollectRowFieldsOperator
    implements CollectRowFieldsOperator {
  private final ItemId itemId;
  private final ValueType type;

  private ImmutableCollectRowFieldsOperator(ItemId itemId, ValueType type) {
    this.itemId = Objects.requireNonNull(itemId, "itemId");
    this.type = Objects.requireNonNull(type, "type");
  }

  private ImmutableCollectRowFieldsOperator(
      ImmutableCollectRowFieldsOperator original,
      ItemId itemId,
      ValueType type) {
    this.itemId = itemId;
    this.type = type;
  }

  /**
   * @return The value of the {@code itemId} attribute
   */
  @Override
  public ItemId getItemId() {
    return itemId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public ValueType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CollectRowFieldsOperator#getItemId() itemId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for itemId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableCollectRowFieldsOperator withItemId(ItemId value) {
    if (this.itemId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "itemId");
    return new ImmutableCollectRowFieldsOperator(this, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CollectRowFieldsOperator#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableCollectRowFieldsOperator withType(ValueType value) {
    if (this.type == value) return this;
    ValueType newValue = Objects.requireNonNull(value, "type");
    return new ImmutableCollectRowFieldsOperator(this, this.itemId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCollectRowFieldsOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCollectRowFieldsOperator
        && equalsByValue((ImmutableCollectRowFieldsOperator) another);
  }

  private boolean equalsByValue(ImmutableCollectRowFieldsOperator another) {
    return itemId.equals(another.itemId)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code itemId}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + itemId.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CollectRowFieldsOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CollectRowFieldsOperator")
        .omitNullValues()
        .add("itemId", itemId)
        .add("type", type)
        .toString();
  }

  /**
   * Construct a new immutable {@code CollectRowFieldsOperator} instance.
   * @param itemId The value for the {@code itemId} attribute
   * @param type The value for the {@code type} attribute
   * @return An immutable CollectRowFieldsOperator instance
   */
  public static ImmutableCollectRowFieldsOperator of(ItemId itemId, ValueType type) {
    return new ImmutableCollectRowFieldsOperator(itemId, type);
  }

  /**
   * Creates an immutable copy of a {@link CollectRowFieldsOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CollectRowFieldsOperator instance
   */
  public static ImmutableCollectRowFieldsOperator copyOf(CollectRowFieldsOperator instance) {
    if (instance instanceof ImmutableCollectRowFieldsOperator) {
      return (ImmutableCollectRowFieldsOperator) instance;
    }
    return ImmutableCollectRowFieldsOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCollectRowFieldsOperator ImmutableCollectRowFieldsOperator}.
   * <pre>
   * ImmutableCollectRowFieldsOperator.builder()
   *    .itemId(io.dialob.session.engine.session.model.ItemId) // required {@link CollectRowFieldsOperator#getItemId() itemId}
   *    .type(io.dialob.rule.parser.api.ValueType) // required {@link CollectRowFieldsOperator#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableCollectRowFieldsOperator builder
   */
  public static ImmutableCollectRowFieldsOperator.Builder builder() {
    return new ImmutableCollectRowFieldsOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCollectRowFieldsOperator ImmutableCollectRowFieldsOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CollectRowFieldsOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ITEM_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ItemId itemId;
    private @Nullable ValueType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CollectRowFieldsOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CollectRowFieldsOperator instance) {
      Objects.requireNonNull(instance, "instance");
      this.itemId(instance.getItemId());
      this.type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link CollectRowFieldsOperator#getItemId() itemId} attribute.
     * @param itemId The value for itemId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder itemId(ItemId itemId) {
      this.itemId = Objects.requireNonNull(itemId, "itemId");
      initBits &= ~INIT_BIT_ITEM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CollectRowFieldsOperator#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(ValueType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCollectRowFieldsOperator ImmutableCollectRowFieldsOperator}.
     * @return An immutable instance of CollectRowFieldsOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCollectRowFieldsOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCollectRowFieldsOperator(null, itemId, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ITEM_ID) != 0) attributes.add("itemId");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build CollectRowFieldsOperator, some of required attributes are not set " + attributes;
    }
  }
}
