package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CoerceToDecimalOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCoerceToDecimalOperator.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableCoerceToDecimalOperator.of()}.
 */
@Generated(from = "CoerceToDecimalOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCoerceToDecimalOperator
    implements CoerceToDecimalOperator {
  private final Expression expression;

  private ImmutableCoerceToDecimalOperator(Expression expression) {
    this.expression = Objects.requireNonNull(expression, "expression");
  }

  private ImmutableCoerceToDecimalOperator(
      ImmutableCoerceToDecimalOperator original,
      Expression expression) {
    this.expression = expression;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @Override
  public Expression getExpression() {
    return expression;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CoerceToDecimalOperator#getExpression() expression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableCoerceToDecimalOperator withExpression(Expression value) {
    if (this.expression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "expression");
    return new ImmutableCoerceToDecimalOperator(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCoerceToDecimalOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCoerceToDecimalOperator
        && equalsByValue((ImmutableCoerceToDecimalOperator) another);
  }

  private boolean equalsByValue(ImmutableCoerceToDecimalOperator another) {
    return expression.equals(another.expression);
  }

  /**
   * Computes a hash code from attributes: {@code expression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + expression.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CoerceToDecimalOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CoerceToDecimalOperator")
        .omitNullValues()
        .add("expression", expression)
        .toString();
  }

  /**
   * Construct a new immutable {@code CoerceToDecimalOperator} instance.
   * @param expression The value for the {@code expression} attribute
   * @return An immutable CoerceToDecimalOperator instance
   */
  public static ImmutableCoerceToDecimalOperator of(Expression expression) {
    return new ImmutableCoerceToDecimalOperator(expression);
  }

  /**
   * Creates an immutable copy of a {@link CoerceToDecimalOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CoerceToDecimalOperator instance
   */
  public static ImmutableCoerceToDecimalOperator copyOf(CoerceToDecimalOperator instance) {
    if (instance instanceof ImmutableCoerceToDecimalOperator) {
      return (ImmutableCoerceToDecimalOperator) instance;
    }
    return ImmutableCoerceToDecimalOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCoerceToDecimalOperator ImmutableCoerceToDecimalOperator}.
   * <pre>
   * ImmutableCoerceToDecimalOperator.builder()
   *    .expression(io.dialob.session.engine.program.model.Expression) // required {@link CoerceToDecimalOperator#getExpression() expression}
   *    .build();
   * </pre>
   * @return A new ImmutableCoerceToDecimalOperator builder
   */
  public static ImmutableCoerceToDecimalOperator.Builder builder() {
    return new ImmutableCoerceToDecimalOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCoerceToDecimalOperator ImmutableCoerceToDecimalOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CoerceToDecimalOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXPRESSION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Expression expression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CoerceToDecimalOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CoerceToDecimalOperator instance) {
      Objects.requireNonNull(instance, "instance");
      this.expression(instance.getExpression());
      return this;
    }

    /**
     * Initializes the value for the {@link CoerceToDecimalOperator#getExpression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expression(Expression expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCoerceToDecimalOperator ImmutableCoerceToDecimalOperator}.
     * @return An immutable instance of CoerceToDecimalOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCoerceToDecimalOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCoerceToDecimalOperator(null, expression);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      return "Cannot build CoerceToDecimalOperator, some of required attributes are not set " + attributes;
    }
  }
}
