package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BinaryOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBinaryOperator.builder()}.
 */
@Generated(from = "BinaryOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBinaryOperator<T>
    implements BinaryOperator<T> {
  private final ImmutableList<Expression> nodes;
  private final Reducer<T> reducer;

  private ImmutableBinaryOperator(
      ImmutableList<Expression> nodes,
      Reducer<T> reducer) {
    this.nodes = nodes;
    this.reducer = reducer;
  }

  /**
   * @return The value of the {@code nodes} attribute
   */
  @Override
  public ImmutableList<Expression> getNodes() {
    return nodes;
  }

  /**
   * @return The value of the {@code reducer} attribute
   */
  @Override
  public Reducer<T> getReducer() {
    return reducer;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BinaryOperator#getNodes() nodes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBinaryOperator<T> withNodes(Expression... elements) {
    ImmutableList<Expression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBinaryOperator<>(newValue, this.reducer);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BinaryOperator#getNodes() nodes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nodes elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableBinaryOperator<T> withNodes(Iterable<? extends Expression> elements) {
    if (this.nodes == elements) return this;
    ImmutableList<Expression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBinaryOperator<>(newValue, this.reducer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BinaryOperator#getReducer() reducer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reducer
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableBinaryOperator<T> withReducer(Reducer<T> value) {
    if (this.reducer == value) return this;
    Reducer<T> newValue = Objects.requireNonNull(value, "reducer");
    return new ImmutableBinaryOperator<>(this.nodes, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBinaryOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBinaryOperator<?>
        && equalsByValue((ImmutableBinaryOperator<?>) another);
  }

  private boolean equalsByValue(ImmutableBinaryOperator<?> another) {
    return nodes.equals(another.nodes)
        && reducer.equals(another.reducer);
  }

  /**
   * Computes a hash code from attributes: {@code nodes}, {@code reducer}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + nodes.hashCode();
    h += (h << 5) + reducer.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BinaryOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BinaryOperator")
        .omitNullValues()
        .add("nodes", nodes)
        .add("reducer", reducer)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link BinaryOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable BinaryOperator instance
   */
  public static <T> ImmutableBinaryOperator<T> copyOf(BinaryOperator<T> instance) {
    if (instance instanceof ImmutableBinaryOperator<?>) {
      return (ImmutableBinaryOperator<T>) instance;
    }
    return ImmutableBinaryOperator.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBinaryOperator ImmutableBinaryOperator}.
   * <pre>
   * ImmutableBinaryOperator.&lt;T&gt;builder()
   *    .addNodes|addAllNodes(io.dialob.session.engine.program.model.Expression) // {@link BinaryOperator#getNodes() nodes} elements
   *    .reducer(io.dialob.session.engine.program.expr.arith.Reducer&lt;T&gt;) // required {@link BinaryOperator#getReducer() reducer}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableBinaryOperator builder
   */
  public static <T> ImmutableBinaryOperator.Builder<T> builder() {
    return new ImmutableBinaryOperator.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableBinaryOperator ImmutableBinaryOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BinaryOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_REDUCER = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<Expression> nodes = ImmutableList.builder();
    private @Nullable Reducer<T> reducer;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BinaryOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(BinaryOperator<T> instance) {
      Objects.requireNonNull(instance, "instance");
      addAllNodes(instance.getNodes());
      this.reducer(instance.getReducer());
      return this;
    }

    /**
     * Adds one element to {@link BinaryOperator#getNodes() nodes} list.
     * @param element A nodes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addNodes(Expression element) {
      this.nodes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link BinaryOperator#getNodes() nodes} list.
     * @param elements An array of nodes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addNodes(Expression... elements) {
      this.nodes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BinaryOperator#getNodes() nodes} list.
     * @param elements An iterable of nodes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> nodes(Iterable<? extends Expression> elements) {
      this.nodes = ImmutableList.builder();
      return addAllNodes(elements);
    }

    /**
     * Adds elements to {@link BinaryOperator#getNodes() nodes} list.
     * @param elements An iterable of nodes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addAllNodes(Iterable<? extends Expression> elements) {
      this.nodes.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link BinaryOperator#getReducer() reducer} attribute.
     * @param reducer The value for reducer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> reducer(Reducer<T> reducer) {
      this.reducer = Objects.requireNonNull(reducer, "reducer");
      initBits &= ~INIT_BIT_REDUCER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBinaryOperator ImmutableBinaryOperator}.
     * @return An immutable instance of BinaryOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBinaryOperator<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBinaryOperator<>(nodes.build(), reducer);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REDUCER) != 0) attributes.add("reducer");
      return "Cannot build BinaryOperator, some of required attributes are not set " + attributes;
    }
  }
}
