/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.boot;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.security.tenant.Tenant;
import io.dialob.session.boot.TenantFromRequestResolver;
import io.dialob.settings.CorsSettings;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;

public class TenantBasedCorsConfigurationSource
implements CorsConfigurationSource {
    private final Function<String, CorsSettings> corsSettingsProvider;
    private final TenantFromRequestResolver tenantFromRequestResolver;

    public TenantBasedCorsConfigurationSource(@NonNull Function<String, CorsSettings> corsSettingsProvider, @NonNull TenantFromRequestResolver tenantFromRequestResolver) {
        this.corsSettingsProvider = corsSettingsProvider;
        this.tenantFromRequestResolver = tenantFromRequestResolver;
    }

    @Nullable
    public CorsConfiguration getCorsConfiguration(@NonNull HttpServletRequest request) {
        return this.corsSettingsProvider.andThen(corsSettings -> Optional.ofNullable(corsSettings == null ? this.corsSettingsProvider.apply("default") : corsSettings)).apply(this.resolveTenantFromRequest(request)).flatMap(CorsSettings::toCorsConfiguration).orElse(null);
    }

    private String resolveTenantFromRequest(HttpServletRequest request) {
        return this.tenantFromRequestResolver.resolveTenantFromRequest(request).map(Tenant::id).orElse(null);
    }
}

