/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.boot;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.security.tenant.Tenant;
import io.dialob.session.boot.TenantFromRequestResolver;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SessionRestTenantFromRequestResolver
implements TenantFromRequestResolver {
    private final QuestionnaireSessionService questionnaireSessionService;

    public SessionRestTenantFromRequestResolver(@NonNull QuestionnaireSessionService questionnaireSessionService) {
        this.questionnaireSessionService = questionnaireSessionService;
    }

    @Override
    public Optional<Tenant> resolveTenantFromRequest(HttpServletRequest request) {
        String sessionId = this.getSessionId(request);
        if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            try {
                return this.getQuestionnaireSession(sessionId).map(QuestionnaireSession::getTenantId).map(Tenant::of);
            }
            catch (DocumentNotFoundException documentNotFoundException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    protected String getSessionId(HttpServletRequest request) {
        String sessionId = request.getParameter("sessionId");
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = StringUtils.substringAfterLast((String)request.getPathInfo(), (String)"/");
        }
        if (!StringUtils.containsOnly((CharSequence)sessionId, (String)"0123456789abcdefABCDEF")) {
            return null;
        }
        return sessionId;
    }

    @NonNull
    protected Optional<QuestionnaireSession> getQuestionnaireSession(String sessionId) {
        return Optional.ofNullable(this.questionnaireSessionService.findOne(sessionId));
    }
}

