/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.boot;

import com.nimbusds.jwt.proc.JWTProcessor;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.questionnaire.service.sockjs.ExtractURIParametersToAttributesInterceptor;
import io.dialob.security.aws.elb.ElbAuthenticationStrategy;
import io.dialob.security.aws.elb.ElbPreAuthenticatedGrantedAuthoritiesUserDetailsService;
import io.dialob.security.aws.elb.PreAuthenticatedCurrentUserProvider;
import io.dialob.security.spring.ApiKeyCurrentUserProvider;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.user.CurrentUserProvider;
import io.dialob.security.user.DelegateCurrentUserProvider;
import io.dialob.security.user.UnauthenticatedCurrentUserProvider;
import io.dialob.session.boot.SessionRestTenantFromRequestResolver;
import io.dialob.session.boot.TenantBasedCorsConfigurationSource;
import io.dialob.session.rest.OnlyOwnerCanAccessSessionPermissionEvaluator;
import io.dialob.session.rest.SessionPermissionEvaluator;
import io.dialob.settings.DialobSettings;
import io.dialob.settings.SessionSettings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.standard.ServletServerContainerFactoryBean;

@Configuration(proxyBeanMethods=false)
public class ApplicationAutoConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationAutoConfiguration.class);

    @Bean
    public AuthenticationManager authenticationManager(List<AuthenticationProvider> providerList) {
        if (providerList.isEmpty()) {
            return authentication -> authentication;
        }
        return new ProviderManager(providerList);
    }

    @Bean
    @ConditionalOnMissingBean(value={CurrentUserProvider.class})
    public CurrentUserProvider anonymousCurrentUserProvider() {
        return UnauthenticatedCurrentUserProvider.INSTANCE;
    }

    @Configuration(proxyBeanMethods=false)
    @EnableWebSocket
    @ConditionalOnProperty(prefix="dialob.session.sockjs", name={"webSocketEnabled"}, havingValue="true")
    public static class SockJSWebSocketConfigurer
    implements WebSocketConfigurer {
        private final WebSocketHandler perConnectionWebSocketHandler;
        private final SessionSettings.SockJSSettings settings;
        private final TaskScheduler taskScheduler;

        public SockJSWebSocketConfigurer(DialobSettings settings, WebSocketHandler perConnectionWebSocketHandler, TaskScheduler taskScheduler) {
            this.perConnectionWebSocketHandler = perConnectionWebSocketHandler;
            this.settings = settings.getSession().getSockjs();
            this.taskScheduler = taskScheduler;
        }

        public void registerWebSocketHandlers(@NonNull WebSocketHandlerRegistry webSocketHandlerRegistry) {
            if (this.settings.isEnabled()) {
                webSocketHandlerRegistry.addHandler(this.perConnectionWebSocketHandler, new String[]{this.settings.getContextPath()}).setAllowedOrigins(this.settings.getAllowedOrigins().toArray(new String[0])).withSockJS().setClientLibraryUrl(this.settings.getLibraryUrl()).setWebSocketEnabled(this.settings.isWebSocketEnabled()).setInterceptors(new HandshakeInterceptor[]{new ExtractURIParametersToAttributesInterceptor(new String[]{Objects.toString(this.settings.getUrlAttributes().getSessionId(), "sessionId"), Objects.toString(this.settings.getUrlAttributes().getTenantId(), "tenantId")})}).setTaskScheduler(this.taskScheduler);
                if (this.settings.isWebSocketEnabled()) {
                    LOGGER.info("Configuring WebSocket endpoint {}", (Object)this.settings.getContextPath());
                }
            }
        }

        @Bean
        public ServletServerContainerFactoryBean createWebSocketContainer() {
            ServletServerContainerFactoryBean container = new ServletServerContainerFactoryBean();
            container.setMaxTextMessageBufferSize(Integer.valueOf(this.settings.getMaxTextMessageBufferSize()));
            container.setMaxBinaryMessageBufferSize(Integer.valueOf(this.settings.getMaxBinaryMessageBufferSize()));
            return container;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="dialob.session.security", name={"enabled"}, havingValue="true")
    public static class AwsSecurityConfiguration {
        @Bean
        public AuthenticationStrategy authenticationStrategy(DialobSettings dialobSettings, GrantedAuthoritiesMapper grantedAuthoritiesMapper, JWTProcessor jwtProcessor, AuthenticationManager authenticationManager) {
            ElbAuthenticationStrategy elbAuthenticationStrategy = new ElbAuthenticationStrategy(grantedAuthoritiesMapper, jwtProcessor, authenticationManager);
            dialobSettings.getAws().getElb().getPrincipalRequestHeader().ifPresent(arg_0 -> ((ElbAuthenticationStrategy)elbAuthenticationStrategy).setPrincipalRequestHeader(arg_0));
            dialobSettings.getAws().getElb().getCredentialsRequestHeader().ifPresent(arg_0 -> ((ElbAuthenticationStrategy)elbAuthenticationStrategy).setCredentialsRequestHeader(arg_0));
            return elbAuthenticationStrategy;
        }

        @Bean
        public AuthenticationProvider authenticationProvider() {
            PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
            authenticationProvider.setThrowExceptionWhenTokenRejected(true);
            authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new ElbPreAuthenticatedGrantedAuthoritiesUserDetailsService());
            return authenticationProvider;
        }

        @Bean
        public CurrentUserProvider currentUserProvider() {
            return new DelegateCurrentUserProvider(new CurrentUserProvider[]{new PreAuthenticatedCurrentUserProvider(), new ApiKeyCurrentUserProvider()});
        }

        @Bean
        public SessionPermissionEvaluator onlyOwnerCanAccessSessionPermissionEvaluator(QuestionnaireSessionService questionnaireSessionService) {
            return new OnlyOwnerCanAccessSessionPermissionEvaluator(questionnaireSessionService);
        }
    }

    @Order(value=50)
    @Configuration(proxyBeanMethods=false)
    @EnableWebSecurity
    public static class RestApiSecurityConfigurer {
        private final SessionSettings sessionSettings;
        private final QuestionnaireSessionService questionnaireSessionService;
        private final Optional<AuthenticationStrategy> authenticationStrategy;

        public RestApiSecurityConfigurer(@NonNull DialobSettings dialobSettings, @NonNull QuestionnaireSessionService questionnaireSessionService, Optional<AuthenticationStrategy> authenticationStrategy) {
            this.sessionSettings = dialobSettings.getSession();
            this.questionnaireSessionService = questionnaireSessionService;
            this.authenticationStrategy = authenticationStrategy;
        }

        @Bean
        SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
            http = http.securityMatcher(AnyRequestMatcher.INSTANCE);
            if (this.authenticationStrategy.isPresent()) {
                this.authenticationStrategy.get().configureAuthentication(http);
            }
            if (this.sessionSettings.getRest().isRequireAuthenticated()) {
                http = http.authorizeHttpRequests(configurer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)configurer.anyRequest()).authenticated());
            }
            return (SecurityFilterChain)http.cors(configurer -> configurer.configurationSource(this.corsConfigurationSource())).csrf(AbstractHttpConfigurer::disable).build();
        }

        CorsConfigurationSource corsConfigurationSource() {
            SessionRestTenantFromRequestResolver tenantFromRequestResolver = new SessionRestTenantFromRequestResolver(this.questionnaireSessionService);
            return new TenantBasedCorsConfigurationSource(this.sessionSettings.getRest().getCors()::get, tenantFromRequestResolver);
        }
    }
}

