/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.integration.redis;

import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.questionnaire.service.api.event.QuestionnaireActionsEvent;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.security.tenant.Tenant;
import io.dialob.security.tenant.TenantContextHolderCurrentTenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

public class UpdateQuestionnaireInCacheOnActionsEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateQuestionnaireInCacheOnActionsEventHandler.class);
    private final Cache questionnaireCache;
    private final QuestionnaireSessionService questionnaireSessionService;

    public UpdateQuestionnaireInCacheOnActionsEventHandler(CacheManager cacheManager, QuestionnaireSessionService questionnaireSessionService) {
        this.questionnaireCache = cacheManager.getCache("questionnaireCache");
        this.questionnaireSessionService = questionnaireSessionService;
    }

    @EventListener
    @Async
    public void onQuestionnaireActionsEvent(QuestionnaireActionsEvent event) {
        TenantContextHolderCurrentTenant.runInTenantContext((Tenant)event.getTenant(), () -> {
            String questionnaireId = event.getQuestionnaireId();
            QuestionnaireSession session = this.questionnaireSessionService.findOne(questionnaireId, false);
            if (session != null) {
                Questionnaire questionnaire = session.getQuestionnaire();
                this.questionnaireCache.put((Object)questionnaireId, (Object)questionnaire);
                LOGGER.debug("Updated questionnaire {} in cache", (Object)questionnaireId);
            }
        });
    }
}

