/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.integration.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.integration.redis.JsonDistributedEventMessageConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.integration.redis.channel.SubscribableRedisChannel;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.converter.MessageConverter;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class DialobIntegrationRedisAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobIntegrationRedisAutoConfiguration.class);

    @Bean(name={"dialobEventsDistributionChannel"})
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    public MessageChannel dialobEventsDistributionChannel(RedisConnectionFactory connectionFactory, ObjectMapper mapper) {
        LOGGER.info("Setting channel {} as SubscribableRedisChannel", (Object)"dialob.node.status");
        SubscribableRedisChannel channel = new SubscribableRedisChannel(connectionFactory, "dialob.node.status");
        channel.setMessageConverter((MessageConverter)new JsonDistributedEventMessageConverter(mapper));
        return channel;
    }
}

