/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.assets.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TemplateDeserializer {
    private static final String REV = "rev";
    private static final String REVS = "revs";
    private static final String TAGS = "tags";

    protected boolean isRevision(ObjectNode input) {
        return input.hasNonNull(REV);
    }

    protected String getRevision(ObjectNode input) {
        return input.get(REV).asText();
    }

    protected Map.Entry<String, List<String>> getRevisions(JsonNode asset) {
        ArrayList revisions = new ArrayList();
        if (asset.hasNonNull(REVS)) {
            JsonNode node = asset.get(REVS);
            node.forEach(n -> revisions.add(n.asText()));
        }
        return new AbstractMap.SimpleImmutableEntry<String, List<String>>("revisions", revisions);
    }

    protected Map.Entry<String, List<String>> getTags(JsonNode asset) {
        ArrayList revisions = new ArrayList();
        if (asset.hasNonNull(TAGS)) {
            JsonNode node = asset.get(TAGS);
            node.forEach(n -> revisions.add(n.asText()));
        }
        return new AbstractMap.SimpleImmutableEntry<String, List<String>>(TAGS, revisions);
    }
}

