/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.assets.serialization;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.dialob.api.form.Form;
import io.dialob.api.form.ImmutableFormMetadata;
import io.dialob.db.assets.serialization.TemplateDeserializer;
import io.dialob.form.service.api.FormDatabase;
import io.dialob.form.service.api.ImmutableFormMetadataRow;
import java.io.IOException;

public class AssetFormMetadataRowDeserializer
extends TemplateDeserializer {
    private final ObjectMapper objectMapper;

    public AssetFormMetadataRowDeserializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public FormDatabase.FormMetadataRow deserialize(ObjectNode input) {
        try {
            JsonNode node = this.objectMapper.readTree(input.get("content").asText());
            ImmutableFormMetadata metadata = ImmutableFormMetadata.builder().from((Form.Metadata)this.objectMapper.treeToValue((TreeNode)node, Form.Metadata.class)).putAdditionalProperties(this.getRevisions((JsonNode)input)).putAdditionalProperties(this.getTags((JsonNode)input)).build();
            String id = input.get("name").textValue();
            return ImmutableFormMetadataRow.of((String)id, (Form.Metadata)metadata);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

