/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.assets;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.dialob.api.form.Form;
import io.dialob.db.assets.repository.AssetRepository;
import io.dialob.db.assets.serialization.AssetFormDeserializer;
import io.dialob.db.assets.serialization.AssetFormMetadataRowDeserializer;
import io.dialob.db.assets.serialization.AssetFormSerializer;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.form.service.api.FormDatabase;
import java.util.function.Consumer;
import org.springframework.lang.NonNull;

public class AssetFormDatabase
implements FormDatabase {
    private final AssetRepository assetRepository;
    private final AssetFormSerializer assetFormSerializer;
    private final AssetFormDeserializer assetFormDeserializer;
    private final AssetFormMetadataRowDeserializer assetFormMetadataRowDeserializer;

    public AssetFormDatabase(AssetRepository assetRepository, AssetFormSerializer assetFormSerializer, AssetFormDeserializer assetFormDeserializer, AssetFormMetadataRowDeserializer assetFormMetadataRowDeserializer) {
        this.assetRepository = assetRepository;
        this.assetFormSerializer = assetFormSerializer;
        this.assetFormDeserializer = assetFormDeserializer;
        this.assetFormMetadataRowDeserializer = assetFormMetadataRowDeserializer;
    }

    @NonNull
    public Form findOne(String tenantId, @NonNull String id, String rev) {
        return this.assetFormDeserializer.deserialize(this.assetRepository.createQuery().id(id).rev(rev).get().orElseThrow(() -> new DocumentNotFoundException(String.format("Can't find document by id = %s, rev = %s!", id, rev))));
    }

    @NonNull
    public Form findOne(String tenantId, @NonNull String id) {
        return this.findOne(tenantId, id, null);
    }

    public boolean exists(String tenantId, @NonNull String id) {
        return this.assetRepository.createQuery().id(id).get().isPresent();
    }

    public boolean delete(String tenantId, @NonNull String id) {
        this.assetRepository.createQuery().id(id).delete();
        return true;
    }

    @NonNull
    public Form save(String tenantId, @NonNull Form document) {
        return this.assetFormDeserializer.deserialize(this.assetRepository.createBuilder().document(this.assetFormSerializer.serialize(document)).build());
    }

    public void findAllMetadata(String tenantId, Form.Metadata metadata, @NonNull Consumer<FormDatabase.FormMetadataRow> consumer) {
        this.assetRepository.createQuery().metadata().list().forEach(e -> consumer.accept(this.assetFormMetadataRowDeserializer.deserialize((ObjectNode)e)));
    }
}

