/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.settings;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.boot.controller.PageAttributes;
import io.dialob.boot.controller.PageSettingsProvider;
import io.dialob.boot.settings.AdminApplicationSettings;
import io.dialob.boot.settings.ComposerApplicationSettings;
import io.dialob.boot.settings.QuestionnaireApplicationSettings;
import io.dialob.boot.settings.ReviewApplicationSettings;
import io.dialob.boot.settings.SettingsPageAttributes;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import io.dialob.security.tenant.CurrentTenant;
import io.dialob.security.tenant.NoTenantInScopeException;
import java.util.Map;
import java.util.Optional;

public class SettingsPageSettingsProvider
implements PageSettingsProvider {
    private final QuestionnaireDatabase questionnaireDatabase;
    private final QuestionnaireApplicationSettings settings;
    private final SettingsPageAttributes defaultPageSettings;
    private final ReviewApplicationSettings reviewSettings;
    private final AdminApplicationSettings adminApplicationSettings;
    private final ComposerApplicationSettings composerApplicationSettings;
    private final SettingsPageAttributes defaultReviewPageSettings;
    private final SettingsPageAttributes defaultAdminPageSettings;
    private final SettingsPageAttributes defaultComposerPageSettings;
    private final CurrentTenant currentTenant;

    public SettingsPageSettingsProvider(CurrentTenant currentTenant, QuestionnaireDatabase questionnaireDatabase, QuestionnaireApplicationSettings settings, ReviewApplicationSettings reviewSettings, ComposerApplicationSettings composerApplicationSettings, Optional<AdminApplicationSettings> adminApplicationSettings) {
        this.currentTenant = currentTenant;
        this.questionnaireDatabase = questionnaireDatabase;
        this.settings = settings;
        this.defaultPageSettings = settings.getTenants().get("default");
        this.reviewSettings = reviewSettings;
        this.adminApplicationSettings = adminApplicationSettings.orElse(null);
        this.composerApplicationSettings = composerApplicationSettings;
        this.defaultReviewPageSettings = reviewSettings.tenants().get("default");
        this.defaultComposerPageSettings = composerApplicationSettings.tenants().get("default");
        this.defaultAdminPageSettings = this.adminApplicationSettings != null ? this.adminApplicationSettings.tenants().get("default") : null;
    }

    @Override
    @NonNull
    public PageAttributes findPageSettingsByQuestionnaireId(String page, String questionnaireId) {
        return this.findTenantFor(questionnaireId).map(tenantId -> this.findPageSettingsByTenantId(page, (String)tenantId)).orElseGet(() -> this.findDefaultSettings(page));
    }

    @Override
    @NonNull
    public PageAttributes findPageSettingsByTenantId(String page, @NonNull String tenantId) {
        SettingsPageAttributes settingsPageAttributes = this.findSettings(page).get(tenantId);
        if (settingsPageAttributes == null) {
            settingsPageAttributes = this.findDefaultSettings(page);
        }
        return settingsPageAttributes;
    }

    @Override
    @NonNull
    public PageAttributes findPageSettings(String page) {
        String tenantId;
        try {
            tenantId = this.currentTenant.getId();
        }
        catch (NoTenantInScopeException e) {
            tenantId = "default";
        }
        return this.findPageSettingsByTenantId(page, tenantId);
    }

    Map<String, SettingsPageAttributes> findSettings(String page) {
        return switch (page) {
            case "fill" -> this.settings.tenants();
            case "review" -> this.reviewSettings.tenants();
            case "admin" -> this.adminApplicationSettings.tenants();
            case "composer" -> this.composerApplicationSettings.tenants();
            default -> throw new IllegalStateException("unknown page " + page);
        };
    }

    SettingsPageAttributes findDefaultSettings(String page) {
        return switch (page) {
            case "fill" -> this.defaultPageSettings;
            case "review" -> this.defaultReviewPageSettings;
            case "admin" -> this.defaultAdminPageSettings;
            case "composer" -> this.defaultComposerPageSettings;
            default -> throw new IllegalStateException("unknown page " + page);
        };
    }

    private Optional<String> findTenantFor(String questionnaireId) {
        try {
            QuestionnaireDatabase.MetadataRow metadataRow = this.questionnaireDatabase.findMetadata(null, questionnaireId);
            return Optional.of(metadataRow.getValue().getTenantId());
        }
        catch (DocumentNotFoundException e) {
            return Optional.empty();
        }
    }
}

