/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.boot.security.AbstractApiSecurityConfigurer;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import io.dialob.settings.DialobSettings;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.SecurityFilterChain;

@Configuration(proxyBeanMethods=false)
@Profile(value={"ui"})
public class WebApiSecurityConfigurer
extends AbstractApiSecurityConfigurer {
    private final DialobSettings settings;

    public WebApiSecurityConfigurer(@NonNull DialobSettings settings, @NonNull TenantAccessEvaluator tenantPermissionEvaluator, AuthenticationStrategy authenticationStrategy) {
        super(settings.getApi().getContextPath(), tenantPermissionEvaluator, authenticationStrategy, settings.getTenant().getMode());
        this.settings = settings;
    }

    @Override
    protected HttpSecurity configureCors(HttpSecurity http) {
        return this.settings.getApi().getCors().toCorsConfiguration().map(corsConfiguration -> {
            try {
                return http.cors(customizer -> customizer.configurationSource(request -> corsConfiguration));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).orElse(http);
    }

    @Bean
    @Order(value=125)
    SecurityFilterChain webApiFilterChain(HttpSecurity http) throws Exception {
        return super.filterChain(http);
    }
}

