/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import com.nimbusds.jwt.proc.JWTProcessor;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.boot.security.ActuatorEndpointSecurityConfiguration;
import io.dialob.boot.security.AdminSecurityConfigurer;
import io.dialob.boot.security.ApiServiceSecurityConfigurer;
import io.dialob.boot.security.ComposerSecurityConfigurer;
import io.dialob.boot.security.OAuth2AuthenticationStrategy;
import io.dialob.boot.security.QuestionnaireSecurityConfigurer;
import io.dialob.boot.security.ReviewSecurityConfigurer;
import io.dialob.boot.security.WebApiSecurityConfigurer;
import io.dialob.security.aws.elb.ElbAuthenticationStrategy;
import io.dialob.security.aws.elb.ElbPreAuthenticatedGrantedAuthoritiesUserDetailsService;
import io.dialob.security.aws.elb.PreAuthenticatedCurrentUserProvider;
import io.dialob.security.key.ServletRequestApiKeyExtractor;
import io.dialob.security.spring.ApiKeyCurrentUserProvider;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.OAuth2SpringSecurityCurrentUserProvider;
import io.dialob.security.spring.apikey.ApiKeyAuthenticationProvider;
import io.dialob.security.spring.apikey.ApiKeyAuthoritiesProvider;
import io.dialob.security.spring.apikey.ApiKeyValidator;
import io.dialob.security.spring.apikey.ClientApiKeyService;
import io.dialob.security.spring.apikey.FixedClientApiKeyService;
import io.dialob.security.spring.apikey.HmacSHA256ApiKeyValidator;
import io.dialob.security.spring.apikey.RequestHeaderApiKeyExtractor;
import io.dialob.security.user.CurrentUserProvider;
import io.dialob.security.user.DelegateCurrentUserProvider;
import io.dialob.settings.DialobSettings;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"dialob.security.enabled"}, havingValue="true")
@EnableWebSecurity
@Import(value={ApiServiceSecurityConfigurer.class})
public class SecurityConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfiguration.class);

    @Bean
    public ServletRequestApiKeyExtractor requestParameterServletApiKeyExtractor() {
        return new RequestHeaderApiKeyExtractor();
    }

    @Bean
    public ApiKeyValidator apiKeyValidator(DialobSettings apiSettings) {
        return new HmacSHA256ApiKeyValidator(apiSettings.getApi().getApiKeySalt().getBytes());
    }

    @Bean
    public ClientApiKeyService clientApiKeyService(DialobSettings apiSettings) {
        List apiKeys = apiSettings.getApi().getApiKeys();
        LOGGER.info("{} api keys found.", (Object)apiKeys.size());
        FixedClientApiKeyService.FixedClientApiKeyServiceBuilder builder = FixedClientApiKeyService.builder();
        apiKeys.forEach(apiKey -> builder.addKey(apiKey.getClientId(), apiKey.getHash(), apiKey.getTenantId(), apiKey.getPermissions()));
        return builder.build();
    }

    @Bean
    AuthenticationProvider apiKeyAuthenticationProvider(@NonNull ClientApiKeyService apiKeyService, @NonNull ApiKeyAuthoritiesProvider apiKeyAuthoritiesProvider, @NonNull ApiKeyValidator apiKeyValidator) {
        return new ApiKeyAuthenticationProvider(apiKeyService, apiKeyAuthoritiesProvider, apiKeyValidator);
    }

    @Bean
    public AuthenticationManager authenticationManager(List<AuthenticationProvider> providerList) {
        if (providerList.isEmpty()) {
            return authentication -> authentication;
        }
        return new ProviderManager(providerList);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"dialob.security.enabled"}, havingValue="true")
    @Import(value={QuestionnaireSecurityConfigurer.class, AdminSecurityConfigurer.class, WebApiSecurityConfigurer.class, ComposerSecurityConfigurer.class, ReviewSecurityConfigurer.class, ActuatorEndpointSecurityConfiguration.class})
    public static class DialobSecurityConfigurerConfiguration {
        @Bean
        @ConditionalOnProperty(name={"dialob.security.authenticationMethod"}, havingValue="OAUTH2", matchIfMissing=true)
        public AuthenticationStrategy authenticationStrategyOauth2(GrantedAuthoritiesMapper grantedAuthoritiesMapper, OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient) {
            return new OAuth2AuthenticationStrategy(grantedAuthoritiesMapper, accessTokenResponseClient);
        }

        @Bean
        @ConditionalOnProperty(name={"dialob.security.authenticationMethod"}, havingValue="AWSELB")
        public AuthenticationStrategy authenticationStrategyElb(DialobSettings dialobSettings, GrantedAuthoritiesMapper grantedAuthoritiesMapper, JWTProcessor jwtProcessor, AuthenticationManager authenticationManager) {
            ElbAuthenticationStrategy elbAuthenticationStrategy = new ElbAuthenticationStrategy(grantedAuthoritiesMapper, jwtProcessor, authenticationManager);
            dialobSettings.getAws().getElb().getPrincipalRequestHeader().ifPresent(arg_0 -> ((ElbAuthenticationStrategy)elbAuthenticationStrategy).setPrincipalRequestHeader(arg_0));
            dialobSettings.getAws().getElb().getCredentialsRequestHeader().ifPresent(arg_0 -> ((ElbAuthenticationStrategy)elbAuthenticationStrategy).setCredentialsRequestHeader(arg_0));
            return elbAuthenticationStrategy;
        }

        @Bean
        @ConditionalOnMissingBean(value={AuthenticationStrategy.class})
        AuthenticationStrategy authenticationStrategyNone() {
            return http -> http;
        }

        @Bean
        public AuthenticationProvider preAuthenticatedAuthenticationProvider() {
            PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
            authenticationProvider.setThrowExceptionWhenTokenRejected(true);
            authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new ElbPreAuthenticatedGrantedAuthoritiesUserDetailsService());
            return authenticationProvider;
        }

        @Bean
        @ConditionalOnProperty(name={"dialob.security.authenticationMethod"}, havingValue="OAUTH2", matchIfMissing=true)
        public CurrentUserProvider currentUserProviderO2() {
            return new DelegateCurrentUserProvider(new CurrentUserProvider[]{new OAuth2SpringSecurityCurrentUserProvider(), new ApiKeyCurrentUserProvider()});
        }

        @Bean
        @ConditionalOnProperty(name={"dialob.security.authenticationMethod"}, havingValue="AWSELB")
        public CurrentUserProvider currentUserProviderELB() {
            return new DelegateCurrentUserProvider(new CurrentUserProvider[]{new PreAuthenticatedCurrentUserProvider(), new ApiKeyCurrentUserProvider()});
        }
    }
}

