/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.security.spring.AuthenticationStrategy;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;

public class OAuth2AuthenticationStrategy
implements AuthenticationStrategy {
    private final GrantedAuthoritiesMapper grantedAuthoritiesMapper;
    private final OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient;

    public OAuth2AuthenticationStrategy(@NonNull GrantedAuthoritiesMapper grantedAuthoritiesMapper, @NonNull OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient) {
        this.grantedAuthoritiesMapper = grantedAuthoritiesMapper;
        this.accessTokenResponseClient = accessTokenResponseClient;
    }

    public HttpSecurity configureAuthentication(@NonNull HttpSecurity http) throws Exception {
        return http.oauth2Login(login -> login.tokenEndpoint(customizer -> customizer.accessTokenResponseClient(this.accessTokenResponseClient)).loginPage("/oauth2/authorization/default").userInfoEndpoint(customizer -> customizer.userAuthoritiesMapper(this.grantedAuthoritiesMapper))).sessionManagement(customizer -> customizer.sessionCreationPolicy(SessionCreationPolicy.ALWAYS));
    }
}

