/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.boot.security.WebUISecurityConfigurer;
import io.dialob.boot.settings.ComposerApplicationSettings;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration(proxyBeanMethods=false)
@Profile(value={"ui"})
public class ComposerSecurityConfigurer
extends WebUISecurityConfigurer {
    public ComposerSecurityConfigurer(@NonNull ComposerApplicationSettings settings, @NonNull TenantAccessEvaluator tenantPermissionEvaluator, @NonNull AuthenticationStrategy authenticationStrategy) {
        super(settings.getContextPath(), tenantPermissionEvaluator, authenticationStrategy);
    }

    @Override
    protected HttpSecurity configurePermissions(HttpSecurity http) throws Exception {
        return http.securityMatcher(this.requestMatcher()).authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.GET, this.getContextPath() + "/**")})).hasAuthority("composer.view").anyRequest()).denyAll());
    }

    @Bean
    @Order(value=130)
    SecurityFilterChain composerFilterChain(HttpSecurity http) throws Exception {
        return super.filterChain(http);
    }
}

