/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.boot.security.AbstractApiSecurityConfigurer;
import io.dialob.security.key.ServletRequestApiKeyExtractor;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.apikey.ApiKeyRequestMatcher;
import io.dialob.security.spring.filter.ApiKeyAuthenticationFilter;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import io.dialob.settings.DialobSettings;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration(proxyBeanMethods=false)
public class ApiServiceSecurityConfigurer
extends AbstractApiSecurityConfigurer {
    public static final RequestMatcher SESSION_NOT_EXISTS_MATCHER = request -> request.getSession(false) == null;
    private final ServletRequestApiKeyExtractor keyRequestExtractor;
    private final AuthenticationManager authenticationManager;
    private final boolean allRequests;
    private RequestMatcher requestMatcher;
    private RequestMatcher apiKeyRequestMatcher;

    public ApiServiceSecurityConfigurer(@NonNull DialobSettings settings, @NonNull ServletRequestApiKeyExtractor keyRequestExtractor, @NonNull TenantAccessEvaluator tenantPermissionEvaluator, @NonNull AuthenticationStrategy authenticationStrategy, @NonNull AuthenticationManager authenticationManager, @NonNull Environment env) {
        super(settings.getApi().getContextPath(), tenantPermissionEvaluator, authenticationStrategy, settings.getTenant().getMode());
        this.keyRequestExtractor = keyRequestExtractor;
        this.authenticationManager = authenticationManager;
        this.allRequests = env.acceptsProfiles(Profiles.of((String[])new String[]{"!ui"}));
    }

    protected RequestMatcher apiKeyRequestMatcher() {
        if (this.apiKeyRequestMatcher == null) {
            this.apiKeyRequestMatcher = this.allRequests ? AnyRequestMatcher.INSTANCE : new ApiKeyRequestMatcher(this.keyRequestExtractor);
        }
        return this.apiKeyRequestMatcher;
    }

    @Override
    protected RequestMatcher requestMatcher() {
        if (this.requestMatcher == null) {
            ArrayList<Object> requestMatchers = new ArrayList<Object>();
            if (StringUtils.isNotBlank((CharSequence)this.getContextPath())) {
                requestMatchers.add(PathPatternRequestMatcher.withDefaults().matcher(this.getContextPath() + "/**"));
            }
            if (!this.allRequests) {
                requestMatchers.add(SESSION_NOT_EXISTS_MATCHER);
                requestMatchers.add(this.apiKeyRequestMatcher());
            }
            this.requestMatcher = requestMatchers.isEmpty() ? AnyRequestMatcher.INSTANCE : new AndRequestMatcher(requestMatchers);
        }
        return this.requestMatcher;
    }

    @Override
    protected HttpSecurity configureAuthentication(HttpSecurity http) throws Exception {
        return http.sessionManagement(configurer -> configurer.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).logout(AbstractHttpConfigurer::disable);
    }

    @Override
    protected HttpSecurity configureCsrf(HttpSecurity http) throws Exception {
        return http.csrf(AbstractHttpConfigurer::disable);
    }

    @Override
    protected HttpSecurity configureFrameOptions(HttpSecurity http) throws Exception {
        return http.headers(customizer -> customizer.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable));
    }

    @Override
    protected HttpSecurity configureMDCPrincipalFilter(HttpSecurity http) throws Exception {
        return super.configureMDCPrincipalFilter(http).addFilterBefore((Filter)new ApiKeyAuthenticationFilter(this.authenticationManager, this.keyRequestExtractor, this.apiKeyRequestMatcher()), AnonymousAuthenticationFilter.class);
    }

    @Bean
    @Order(value=-2147483648)
    SecurityFilterChain apiFilterChain(HttpSecurity http) throws Exception {
        return super.filterChain(http);
    }
}

