/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.boot.security.WebUISecurityConfigurer;
import io.dialob.boot.settings.AdminApplicationSettings;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration(proxyBeanMethods=false)
@Profile(value={"ui"})
public class AdminSecurityConfigurer
extends WebUISecurityConfigurer {
    public AdminSecurityConfigurer(@NonNull AdminApplicationSettings settings, @NonNull TenantAccessEvaluator tenantPermissionEvaluator, @NonNull AuthenticationStrategy authenticationStrategy) {
        super(settings.getContextPath(), tenantPermissionEvaluator, authenticationStrategy);
    }

    @Override
    protected HttpSecurity configurePermissions(HttpSecurity http) throws Exception {
        PathPatternRequestMatcher.Builder path = PathPatternRequestMatcher.withDefaults();
        String contextPath = StringUtils.prependIfMissing((String)StringUtils.removeEnd((String)this.getContextPath(), (String)"/"), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return http.securityMatcher(this.requestMatcher()).authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.GET, contextPath + "/v3/api-docs/**")})).permitAll().requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.GET, contextPath + "/swagger-ui/**")})).permitAll().requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.GET, contextPath + "/webjars/**")})).permitAll().requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.GET, contextPath + "**")})).hasAuthority("manager.view").anyRequest()).denyAll());
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    SecurityFilterChain adminFilterChain(HttpSecurity http) throws Exception {
        return super.filterChain(http);
    }
}

