/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.security.aws.elb.ElbAuthenticationStrategy;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.filter.MDCPrincipalFilter;
import io.dialob.security.spring.tenant.DefaultTenantGrantedAuthorityProvider;
import io.dialob.security.spring.tenant.DefaultTenantSupplier;
import io.dialob.security.spring.tenant.RequestParameterTenantScopeFilter;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import jakarta.servlet.Filter;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public abstract class AbstractWebSecurityConfigurer {
    private static final MDCPrincipalFilter MDC_PRINCIPAL_FILTER = new MDCPrincipalFilter();
    private final String contextPath;
    private final TenantAccessEvaluator tenantPermissionEvaluator;
    private final AuthenticationStrategy authenticationStrategy;
    private final CookieCsrfTokenRepository csrfTokenRepository = new CookieCsrfTokenRepository();

    public AbstractWebSecurityConfigurer(String contextPath, TenantAccessEvaluator tenantPermissionEvaluator, AuthenticationStrategy authenticationStrategy) {
        this.contextPath = Objects.toString(contextPath, "/");
        this.tenantPermissionEvaluator = tenantPermissionEvaluator;
        this.authenticationStrategy = authenticationStrategy;
    }

    SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http = this.configurePermissions(http);
        http = this.configureLogout(http);
        http = this.configureFrameOptions(http);
        http = this.configureAuthenticationManager(http);
        http = this.configureCsrf(http);
        http = this.configureAuthentication(http);
        http = this.configureCors(http);
        http = this.configureRequestParameterTenantScopeFilter(http);
        http = this.configureMDCPrincipalFilter(http);
        return (SecurityFilterChain)http.build();
    }

    protected HttpSecurity configureAuthenticationManager(HttpSecurity http) {
        return http;
    }

    protected abstract HttpSecurity configurePermissions(HttpSecurity var1) throws Exception;

    protected RequestMatcher requestMatcher() {
        return PathPatternRequestMatcher.withDefaults().matcher(StringUtils.appendIfMissing((String)this.getContextPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "**");
    }

    protected HttpSecurity configureMDCPrincipalFilter(HttpSecurity http) throws Exception {
        return http.addFilterAfter((Filter)MDC_PRINCIPAL_FILTER, AnonymousAuthenticationFilter.class);
    }

    protected HttpSecurity configureRequestParameterTenantScopeFilter(HttpSecurity http) {
        this.getRequestParameterTenantScopeFilter().ifPresent(requestParameterTenantScopeFilter -> http.addFilterAfter((Filter)requestParameterTenantScopeFilter, ExceptionTranslationFilter.class));
        return http;
    }

    protected HttpSecurity configureCsrf(HttpSecurity http) throws Exception {
        if (this.authenticationStrategy instanceof ElbAuthenticationStrategy) {
            return http.csrf(customizer -> customizer.csrfTokenRepository((CsrfTokenRepository)this.csrfTokenRepository).sessionAuthenticationStrategy((authentication, request, response) -> {}));
        }
        return http;
    }

    protected HttpSecurity configureCors(HttpSecurity http) throws Exception {
        return http;
    }

    protected HttpSecurity configureAuthentication(HttpSecurity http) throws Exception {
        return this.authenticationStrategy.configureAuthentication(http);
    }

    protected HttpSecurity configureFrameOptions(HttpSecurity http) throws Exception {
        return http.headers(customizer -> customizer.frameOptions(HeadersConfigurer.FrameOptionsConfig::sameOrigin));
    }

    protected HttpSecurity configureLogout(HttpSecurity http) throws Exception {
        return http.logout(customizer -> customizer.logoutRequestMatcher((RequestMatcher)PathPatternRequestMatcher.withDefaults().matcher("/logout")).logoutSuccessUrl("/"));
    }

    protected final String getContextPath() {
        return this.contextPath;
    }

    @NonNull
    protected Optional<RequestParameterTenantScopeFilter> getRequestParameterTenantScopeFilter() {
        RequestParameterTenantScopeFilter requestParameterTenantScopeFilter = new RequestParameterTenantScopeFilter(this.getTenantPermissionEvaluator(), (DefaultTenantSupplier)this.getDefaultTenantSupplier());
        requestParameterTenantScopeFilter.setTenantRequiredMatcher(this.getTenantRequiredMatcher());
        return Optional.of(requestParameterTenantScopeFilter);
    }

    @NonNull
    protected RequestMatcher getTenantRequiredMatcher() {
        return request -> false;
    }

    @NonNull
    protected TenantAccessEvaluator getTenantPermissionEvaluator() {
        return this.tenantPermissionEvaluator;
    }

    @NonNull
    protected DefaultTenantGrantedAuthorityProvider getDefaultTenantSupplier() {
        return new DefaultTenantGrantedAuthorityProvider();
    }
}

