/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.boot.security.AbstractWebSecurityConfigurer;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import io.dialob.settings.DialobSettings;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public abstract class AbstractApiSecurityConfigurer
extends AbstractWebSecurityConfigurer {
    private final DialobSettings.TenantSettings.Mode tenantMode;

    public AbstractApiSecurityConfigurer(String contextPath, TenantAccessEvaluator tenantPermissionEvaluator, @NonNull AuthenticationStrategy authenticationStrategy, DialobSettings.TenantSettings.Mode tenantMode) {
        super(contextPath, tenantPermissionEvaluator, authenticationStrategy);
        this.tenantMode = tenantMode;
    }

    @Override
    protected HttpSecurity configurePermissions(@NonNull HttpSecurity http) throws Exception {
        PathPatternRequestMatcher.Builder path = PathPatternRequestMatcher.withDefaults();
        return http.securityMatcher(this.requestMatcher()).authorizeHttpRequests(registry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.GET, this.getContextPath() + "/questionnaires/**")})).hasAuthority("questionnaires.get").requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.HEAD, this.getContextPath() + "/questionnaires/**")})).hasAuthority("questionnaires.get").requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.POST, this.getContextPath() + "/questionnaires/**")})).hasAuthority("questionnaires.post").requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.PUT, this.getContextPath() + "/questionnaires/**")})).hasAuthority("questionnaires.put").requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.DELETE, this.getContextPath() + "/questionnaires/**")})).hasAuthority("questionnaires.delete").requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.GET, this.getContextPath() + "/forms/**")})).hasAuthority("forms.get").requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.HEAD, this.getContextPath() + "/forms/**")})).hasAuthority("forms.get").requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.POST, this.getContextPath() + "/forms/**")})).hasAuthority("forms.post").requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.PUT, this.getContextPath() + "/forms/**")})).hasAuthority("forms.put").requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.DELETE, this.getContextPath() + "/forms/**")})).hasAuthority("forms.delete").requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.GET, this.getContextPath() + "/tags/**")})).hasAuthority("forms.get").requestMatchers(new RequestMatcher[]{path.matcher(HttpMethod.GET, this.getContextPath() + "/tenants/**")})).authenticated().anyRequest()).denyAll());
    }

    @Override
    @NonNull
    protected RequestMatcher getTenantRequiredMatcher() {
        if (this.tenantMode == DialobSettings.TenantSettings.Mode.URL_PARAM) {
            return new NegatedRequestMatcher((RequestMatcher)PathPatternRequestMatcher.withDefaults().matcher(this.getContextPath() + "/tenants/**"));
        }
        return super.getTenantRequiredMatcher();
    }
}

