/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.form.Form;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.boot.controller.BaseController;
import io.dialob.boot.controller.PageAttributes;
import io.dialob.boot.controller.PageSettingsProvider;
import io.dialob.boot.settings.ReviewApplicationSettings;
import io.dialob.form.service.api.FormDatabase;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import io.dialob.security.tenant.CurrentTenant;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${review.context-path:/review}"})
public class ReviewController
extends BaseController {
    private final CurrentTenant currentTenant;
    private final ReviewApplicationSettings settings;
    private final QuestionnaireDatabase questionnaireRepository;
    private final FormDatabase formDatabase;
    private final ObjectMapper objectMapper;
    private final PageSettingsProvider pageSettingsProvider;

    public ReviewController(ReviewApplicationSettings settings, QuestionnaireDatabase questionnaireRepository, FormDatabase formDatabase, ObjectMapper objectMapper, CurrentTenant currentTenant, PageSettingsProvider pageSettingsProvider) {
        this.settings = settings;
        this.questionnaireRepository = questionnaireRepository;
        this.formDatabase = formDatabase;
        this.objectMapper = objectMapper;
        this.currentTenant = currentTenant;
        this.pageSettingsProvider = pageSettingsProvider;
    }

    @GetMapping(value={"/{questionnaireId}"}, produces={"text/html"})
    public String review(@Valid GetReview getReview, CsrfToken cfrsToken, Model model, HttpServletRequest request) throws JsonProcessingException {
        ReviewOptions.ReviewOptionsBuilder reviewOptionsBuilder = ReviewOptions.builder().apiUrl(this.settings.getApiUrl()).questionnaireId(getReview.questionnaireId()).csrf(cfrsToken);
        String tenantId = request.getParameter("tenantId");
        if (!StringUtils.isBlank((CharSequence)tenantId)) {
            reviewOptionsBuilder.tenantId(tenantId);
        }
        if (StringUtils.isBlank((CharSequence)this.settings.getApiUrl())) {
            Questionnaire questionnaire = this.questionnaireRepository.findOne(this.currentTenant.getId(), getReview.questionnaireId());
            Questionnaire.Metadata metadata = questionnaire.getMetadata();
            String formRev = "LATEST".equals(metadata.getFormRev()) ? null : metadata.getFormRev();
            Form form = this.formDatabase.findOne(this.currentTenant.getId(), metadata.getFormId(), formRev);
            reviewOptionsBuilder.form(this.objectMapper.writeValueAsString((Object)form));
            reviewOptionsBuilder.sessionData(this.objectMapper.writeValueAsString((Object)questionnaire));
        }
        model.addAttribute("reviewOptions", (Object)reviewOptionsBuilder.build());
        PageAttributes pageAttributes = this.pageSettingsProvider.findPageSettingsByQuestionnaireId("review", getReview.questionnaireId());
        model.addAllAttributes(pageAttributes.getAttributes());
        this.index(model, request);
        return pageAttributes.getTemplate();
    }

    public record ReviewOptions(String apiUrl, String questionnaireId, CsrfToken csrf, String form, String sessionData, String tenantId) {
        @Generated
        public static ReviewOptionsBuilder builder() {
            return new ReviewOptionsBuilder();
        }

        @Generated
        public static class ReviewOptionsBuilder {
            @Generated
            private String apiUrl;
            @Generated
            private String questionnaireId;
            @Generated
            private CsrfToken csrf;
            @Generated
            private String form;
            @Generated
            private String sessionData;
            @Generated
            private String tenantId;

            @Generated
            ReviewOptionsBuilder() {
            }

            @Generated
            public ReviewOptionsBuilder apiUrl(String apiUrl) {
                this.apiUrl = apiUrl;
                return this;
            }

            @Generated
            public ReviewOptionsBuilder questionnaireId(String questionnaireId) {
                this.questionnaireId = questionnaireId;
                return this;
            }

            @Generated
            public ReviewOptionsBuilder csrf(CsrfToken csrf) {
                this.csrf = csrf;
                return this;
            }

            @Generated
            public ReviewOptionsBuilder form(String form) {
                this.form = form;
                return this;
            }

            @Generated
            public ReviewOptionsBuilder sessionData(String sessionData) {
                this.sessionData = sessionData;
                return this;
            }

            @Generated
            public ReviewOptionsBuilder tenantId(String tenantId) {
                this.tenantId = tenantId;
                return this;
            }

            @Generated
            public ReviewOptions build() {
                return new ReviewOptions(this.apiUrl, this.questionnaireId, this.csrf, this.form, this.sessionData, this.tenantId);
            }

            @Generated
            public String toString() {
                return "ReviewController.ReviewOptions.ReviewOptionsBuilder(apiUrl=" + this.apiUrl + ", questionnaireId=" + this.questionnaireId + ", csrf=" + String.valueOf(this.csrf) + ", form=" + this.form + ", sessionData=" + this.sessionData + ", tenantId=" + this.tenantId + ")";
            }
        }
    }

    public record GetReview(@Pattern(regexp="[\\p{XDigit}-]{1,64}") @Pattern(regexp="[\\p{XDigit}-]{1,64}") String questionnaireId) {
    }
}

