/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.controller;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.boot.controller.PageAttributes;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PageAttributes", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutablePageAttributes
implements PageAttributes {
    private final ImmutableMap<String, Object> attributes;
    private final String template;

    private ImmutablePageAttributes(ImmutableMap<String, Object> attributes, String template) {
        this.attributes = attributes;
        this.template = template;
    }

    public ImmutableMap<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    public final ImmutablePageAttributes withAttributes(Map<String, ? extends Object> entries) {
        if (this.attributes == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutablePageAttributes((ImmutableMap<String, Object>)newValue, this.template);
    }

    public final ImmutablePageAttributes withTemplate(String value) {
        String newValue = Objects.requireNonNull(value, "template");
        if (this.template.equals(newValue)) {
            return this;
        }
        return new ImmutablePageAttributes(this.attributes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageAttributes && this.equalsByValue((ImmutablePageAttributes)another);
    }

    private boolean equalsByValue(ImmutablePageAttributes another) {
        return this.attributes.equals(another.attributes) && this.template.equals(another.template);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.attributes.hashCode();
        h += (h << 5) + this.template.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PageAttributes").omitNullValues().add("attributes", this.attributes).add("template", (Object)this.template).toString();
    }

    public static ImmutablePageAttributes copyOf(PageAttributes instance) {
        if (instance instanceof ImmutablePageAttributes) {
            return (ImmutablePageAttributes)instance;
        }
        return ImmutablePageAttributes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PageAttributes", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEMPLATE = 1L;
        private long initBits = 1L;
        private ImmutableMap.Builder<String, Object> attributes = ImmutableMap.builder();
        @Nullable
        private String template;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PageAttributes instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllAttributes(instance.getAttributes());
            this.template(instance.getTemplate());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAttributes(String key, Object value) {
            this.attributes.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAttributes(Map.Entry<String, ? extends Object> entry) {
            this.attributes.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attributes(Map<String, ? extends Object> entries) {
            this.attributes = ImmutableMap.builder();
            return this.putAllAttributes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllAttributes(Map<String, ? extends Object> entries) {
            this.attributes.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder template(String template) {
            this.template = Objects.requireNonNull(template, "template");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePageAttributes build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageAttributes((ImmutableMap<String, Object>)this.attributes.build(), this.template);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("template");
            }
            return "Cannot build PageAttributes, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

