/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.controller;

import io.dialob.boot.controller.BaseController;
import io.dialob.boot.controller.PageAttributes;
import io.dialob.boot.controller.PageSettingsProvider;
import io.dialob.boot.settings.QuestionnaireApplicationSettings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${fill.context-path:/fill}"})
public class FillController
extends BaseController {
    private final QuestionnaireApplicationSettings settings;
    private final PageSettingsProvider pageSettingsProvider;

    public FillController(QuestionnaireApplicationSettings settings, PageSettingsProvider pageSettingsProvider) {
        this.settings = settings;
        this.pageSettingsProvider = pageSettingsProvider;
    }

    @GetMapping(value={"/{questionnaireId}"}, produces={"text/html"})
    public String fill(@PathVariable(value="questionnaireId") @Pattern(regexp="[\\p{XDigit}-]{1,64}") @Pattern(regexp="[\\p{XDigit}-]{1,64}") String questionnaireId, CsrfToken cfrsToken, Model model, HttpServletRequest request) {
        model.addAttribute("formConnectionOptions", (Object)FormConnectionOptions.builder().questionnaireId(questionnaireId).url(this.settings.getSocketUrl() + "/" + questionnaireId).reviewUrl(this.settings.getReviewUrl() + "/" + questionnaireId).csrf(cfrsToken).restUrl(this.settings.getRestUrl() + "/" + questionnaireId).restUrlBase(this.settings.getRestUrl()).connectionMode(this.settings.getConnectionMode()).backendApiUrl(this.settings.getBackendApiUrl()).build());
        PageAttributes pageAttributes = this.pageSettingsProvider.findPageSettingsByQuestionnaireId("fill", questionnaireId);
        model.addAllAttributes(pageAttributes.getAttributes());
        this.index(model, request);
        return pageAttributes.getTemplate();
    }

    public record FormConnectionOptions(String url, String reviewUrl, String questionnaireId, List<String> transports, CsrfToken csrf, String restUrl, String restUrlBase, String connectionMode, String backendApiUrl) {
        @Generated
        public static FormConnectionOptionsBuilder builder() {
            return new FormConnectionOptionsBuilder();
        }

        @Generated
        public static class FormConnectionOptionsBuilder {
            @Generated
            private String url;
            @Generated
            private String reviewUrl;
            @Generated
            private String questionnaireId;
            @Generated
            private List<String> transports;
            @Generated
            private CsrfToken csrf;
            @Generated
            private String restUrl;
            @Generated
            private String restUrlBase;
            @Generated
            private String connectionMode;
            @Generated
            private String backendApiUrl;

            @Generated
            FormConnectionOptionsBuilder() {
            }

            @Generated
            public FormConnectionOptionsBuilder url(String url) {
                this.url = url;
                return this;
            }

            @Generated
            public FormConnectionOptionsBuilder reviewUrl(String reviewUrl) {
                this.reviewUrl = reviewUrl;
                return this;
            }

            @Generated
            public FormConnectionOptionsBuilder questionnaireId(String questionnaireId) {
                this.questionnaireId = questionnaireId;
                return this;
            }

            @Generated
            public FormConnectionOptionsBuilder transports(List<String> transports) {
                this.transports = transports;
                return this;
            }

            @Generated
            public FormConnectionOptionsBuilder csrf(CsrfToken csrf) {
                this.csrf = csrf;
                return this;
            }

            @Generated
            public FormConnectionOptionsBuilder restUrl(String restUrl) {
                this.restUrl = restUrl;
                return this;
            }

            @Generated
            public FormConnectionOptionsBuilder restUrlBase(String restUrlBase) {
                this.restUrlBase = restUrlBase;
                return this;
            }

            @Generated
            public FormConnectionOptionsBuilder connectionMode(String connectionMode) {
                this.connectionMode = connectionMode;
                return this;
            }

            @Generated
            public FormConnectionOptionsBuilder backendApiUrl(String backendApiUrl) {
                this.backendApiUrl = backendApiUrl;
                return this;
            }

            @Generated
            public FormConnectionOptions build() {
                return new FormConnectionOptions(this.url, this.reviewUrl, this.questionnaireId, this.transports, this.csrf, this.restUrl, this.restUrlBase, this.connectionMode, this.backendApiUrl);
            }

            @Generated
            public String toString() {
                return "FillController.FormConnectionOptions.FormConnectionOptionsBuilder(url=" + this.url + ", reviewUrl=" + this.reviewUrl + ", questionnaireId=" + this.questionnaireId + ", transports=" + String.valueOf(this.transports) + ", csrf=" + String.valueOf(this.csrf) + ", restUrl=" + this.restUrl + ", restUrlBase=" + this.restUrlBase + ", connectionMode=" + this.connectionMode + ", backendApiUrl=" + this.backendApiUrl + ")";
            }
        }
    }
}

