/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.controller;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.boot.controller.BaseController;
import io.dialob.boot.controller.PageAttributes;
import io.dialob.boot.controller.PageSettingsProvider;
import io.dialob.boot.settings.ComposerApplicationSettings;
import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${composer.context-path:/composer}"})
public class ComposerController
extends BaseController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ComposerController.class);
    @Value(value="${info.build.version}")
    private String version;
    private final ComposerApplicationSettings settings;
    private final PageSettingsProvider pageSettingsProvider;

    public ComposerController(ComposerApplicationSettings settings, PageSettingsProvider pageSettingsProvider) {
        this.settings = settings;
        this.pageSettingsProvider = pageSettingsProvider;
    }

    @GetMapping(value={"/"}, produces={"text/html"})
    public String composer(@RequestHeader(value="X-Forwarded-For", required=false) String forwardedFor, @RequestHeader(value="Host", required=false) String host, @RequestHeader(value="X-Real-IP", required=false) String realIp, @RequestHeader(value="X-Forwarded-Proto", required=false) String forwardedProto, CsrfToken csrfToken, @RequestParam(name="tenantId", required=false) String tenantId, Model model, HttpServletRequest request) {
        return this.composer(forwardedFor, host, realIp, forwardedProto, null, csrfToken, tenantId, model, request);
    }

    @GetMapping(value={"/{id}"}, produces={"text/html"})
    public String composer(@RequestHeader(value="X-Forwarded-For", required=false) String forwardedFor, @RequestHeader(value="Host", required=false) String host, @RequestHeader(value="X-Real-IP", required=false) String realIp, @RequestHeader(value="X-Forwarded-Proto", required=false) String forwardedProto, @PathVariable(value="id") String formId, CsrfToken cfrsToken, @RequestParam(name="tenantId", required=false) String tenantId, Model model, HttpServletRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Host: {}", (Object)host);
            LOGGER.debug("X-Real-IP: {}", (Object)realIp);
            LOGGER.debug("X-Forwarded-For: {}", (Object)forwardedFor);
            LOGGER.debug("X-Forwarded-Proto: {}", (Object)forwardedProto);
        }
        if ("index.html".equals(formId)) {
            formId = null;
        }
        this.index(model, request);
        if (StringUtils.isBlank((CharSequence)forwardedProto)) {
            forwardedProto = request.getScheme();
        }
        ComposerConfig appConfig = this.getJavascriptAppConfig(host, forwardedProto, formId, cfrsToken, tenantId);
        model.addAttribute("contextPath", (Object)this.settings.getUrl());
        model.addAttribute("subApplicationName", (Object)this.settings.getSubApplicationName());
        model.addAttribute("appConfig", (Object)appConfig);
        PageAttributes pageAttributes = this.pageSettingsProvider.findPageSettings("composer");
        model.addAllAttributes(pageAttributes.getAttributes());
        this.index(model, request);
        return pageAttributes.getTemplate();
    }

    @GetMapping(path={"/{id}/config.json"}, produces={"application/json"})
    @ResponseBody
    public ComposerConfig config(@RequestHeader(value="Host", required=false) String host, @RequestHeader(value="X-Forwarded-Proto", required=false) String forwardedProto, @PathVariable(value="id") String formId, CsrfToken cfrsToken, @RequestParam(name="tenantId", required=false) String tenantId) {
        return this.getJavascriptAppConfig(host, forwardedProto, formId, cfrsToken, tenantId);
    }

    protected ComposerConfig getJavascriptAppConfig(String host, String forwardedProto, String formId, CsrfToken cfrsToken, @RequestParam(name="tenantId", required=false) String tenantId) {
        Object fillingAppUrl = this.settings.getFillingAppUrl();
        if (StringUtils.isBlank((CharSequence)fillingAppUrl)) {
            fillingAppUrl = forwardedProto + "://" + host;
        }
        return ComposerConfig.builder().formId(formId).backendApiUrl(this.settings.getBackendApiUrl()).documentationUrl(this.settings.getDocumentationUrl()).fillingAppUrl((String)fillingAppUrl).adminAppUrl(this.settings.getAdminAppUrl()).csrf(cfrsToken != null ? cfrsToken.getToken() : null).csrfHeader(cfrsToken != null ? cfrsToken.getHeaderName() : null).tenantId(ComposerController.isValidTenantId(tenantId) ? tenantId : null).version(this.version).build();
    }

    public record ComposerConfig(@JsonProperty(value="backend_api_url") String backendApiUrl, @JsonProperty(value="documentation_url") String documentationUrl, @JsonProperty(value="filling_app_url") String fillingAppUrl, String csrf, String csrfHeader, String formId, String adminAppUrl, String tenantId, String version) {
        @Generated
        public static ComposerConfigBuilder builder() {
            return new ComposerConfigBuilder();
        }

        @Generated
        public static class ComposerConfigBuilder {
            @Generated
            private String backendApiUrl;
            @Generated
            private String documentationUrl;
            @Generated
            private String fillingAppUrl;
            @Generated
            private String csrf;
            @Generated
            private String csrfHeader;
            @Generated
            private String formId;
            @Generated
            private String adminAppUrl;
            @Generated
            private String tenantId;
            @Generated
            private String version;

            @Generated
            ComposerConfigBuilder() {
            }

            @JsonProperty(value="backend_api_url")
            @Generated
            public ComposerConfigBuilder backendApiUrl(String backendApiUrl) {
                this.backendApiUrl = backendApiUrl;
                return this;
            }

            @JsonProperty(value="documentation_url")
            @Generated
            public ComposerConfigBuilder documentationUrl(String documentationUrl) {
                this.documentationUrl = documentationUrl;
                return this;
            }

            @JsonProperty(value="filling_app_url")
            @Generated
            public ComposerConfigBuilder fillingAppUrl(String fillingAppUrl) {
                this.fillingAppUrl = fillingAppUrl;
                return this;
            }

            @Generated
            public ComposerConfigBuilder csrf(String csrf) {
                this.csrf = csrf;
                return this;
            }

            @Generated
            public ComposerConfigBuilder csrfHeader(String csrfHeader) {
                this.csrfHeader = csrfHeader;
                return this;
            }

            @Generated
            public ComposerConfigBuilder formId(String formId) {
                this.formId = formId;
                return this;
            }

            @Generated
            public ComposerConfigBuilder adminAppUrl(String adminAppUrl) {
                this.adminAppUrl = adminAppUrl;
                return this;
            }

            @Generated
            public ComposerConfigBuilder tenantId(String tenantId) {
                this.tenantId = tenantId;
                return this;
            }

            @Generated
            public ComposerConfigBuilder version(String version) {
                this.version = version;
                return this;
            }

            @Generated
            public ComposerConfig build() {
                return new ComposerConfig(this.backendApiUrl, this.documentationUrl, this.fillingAppUrl, this.csrf, this.csrfHeader, this.formId, this.adminAppUrl, this.tenantId, this.version);
            }

            @Generated
            public String toString() {
                return "ComposerController.ComposerConfig.ComposerConfigBuilder(backendApiUrl=" + this.backendApiUrl + ", documentationUrl=" + this.documentationUrl + ", fillingAppUrl=" + this.fillingAppUrl + ", csrf=" + this.csrf + ", csrfHeader=" + this.csrfHeader + ", formId=" + this.formId + ", adminAppUrl=" + this.adminAppUrl + ", tenantId=" + this.tenantId + ", version=" + this.version + ")";
            }
        }
    }
}

