/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.controller;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.boot.controller.BaseController;
import io.dialob.boot.controller.PageAttributes;
import io.dialob.boot.controller.PageSettingsProvider;
import io.dialob.boot.settings.AdminApplicationSettings;
import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${admin.context-path:/}"})
public class AdminController
extends BaseController {
    private final AdminApplicationSettings settings;
    private final PageSettingsProvider pageSettingsProvider;

    public AdminController(AdminApplicationSettings settings, PageSettingsProvider pageSettingsProvider) {
        this.settings = settings;
        this.pageSettingsProvider = pageSettingsProvider;
    }

    @GetMapping(path={"", "/index.html"}, produces={"text/html"})
    public String index(CsrfToken cfrsToken, Model model, @RequestParam(name="tenantId", required=false) String tenantId, HttpServletRequest request) {
        model.addAttribute("_csrf", (Object)cfrsToken);
        model.addAttribute("adminConfig", (Object)this.getAdminConfig(cfrsToken, tenantId));
        PageAttributes pageAttributes = this.pageSettingsProvider.findPageSettings("admin");
        model.addAllAttributes(pageAttributes.getAttributes());
        this.index(model, request);
        return pageAttributes.getTemplate();
    }

    @GetMapping(path={"/config.json"}, produces={"application/json"})
    @ResponseBody
    public AdminConfig config(CsrfToken cfrsToken, @RequestParam(name="tenantId", required=false) String tenantId) {
        return this.getAdminConfig(cfrsToken, tenantId);
    }

    @NonNull
    public AdminConfig getAdminConfig(CsrfToken csrf, String tenantId) {
        AdminConfig.AdminConfigBuilder config = AdminConfig.builder().csrf(csrf).url(this.settings.apiUrl()).fillUrl(this.settings.fillingAppUrl()).reviewUrl(this.settings.reviewAppUrl()).documentation(this.settings.documentation()).composerUrl(this.settings.composerAppUrl()).versioning(this.settings.versioning());
        if (AdminController.isValidTenantId(tenantId)) {
            config.tenantId(tenantId);
        }
        return config.build();
    }

    public record AdminConfig(String url, String documentation, String fillUrl, String reviewUrl, CsrfToken csrf, String composerUrl, String tenantId, boolean versioning) {
        @Generated
        public static AdminConfigBuilder builder() {
            return new AdminConfigBuilder();
        }

        @Generated
        public static class AdminConfigBuilder {
            @Generated
            private String url;
            @Generated
            private String documentation;
            @Generated
            private String fillUrl;
            @Generated
            private String reviewUrl;
            @Generated
            private CsrfToken csrf;
            @Generated
            private String composerUrl;
            @Generated
            private String tenantId;
            @Generated
            private boolean versioning;

            @Generated
            AdminConfigBuilder() {
            }

            @Generated
            public AdminConfigBuilder url(String url) {
                this.url = url;
                return this;
            }

            @Generated
            public AdminConfigBuilder documentation(String documentation) {
                this.documentation = documentation;
                return this;
            }

            @Generated
            public AdminConfigBuilder fillUrl(String fillUrl) {
                this.fillUrl = fillUrl;
                return this;
            }

            @Generated
            public AdminConfigBuilder reviewUrl(String reviewUrl) {
                this.reviewUrl = reviewUrl;
                return this;
            }

            @Generated
            public AdminConfigBuilder csrf(CsrfToken csrf) {
                this.csrf = csrf;
                return this;
            }

            @Generated
            public AdminConfigBuilder composerUrl(String composerUrl) {
                this.composerUrl = composerUrl;
                return this;
            }

            @Generated
            public AdminConfigBuilder tenantId(String tenantId) {
                this.tenantId = tenantId;
                return this;
            }

            @Generated
            public AdminConfigBuilder versioning(boolean versioning) {
                this.versioning = versioning;
                return this;
            }

            @Generated
            public AdminConfig build() {
                return new AdminConfig(this.url, this.documentation, this.fillUrl, this.reviewUrl, this.csrf, this.composerUrl, this.tenantId, this.versioning);
            }

            @Generated
            public String toString() {
                return "AdminController.AdminConfig.AdminConfigBuilder(url=" + this.url + ", documentation=" + this.documentation + ", fillUrl=" + this.fillUrl + ", reviewUrl=" + this.reviewUrl + ", csrf=" + String.valueOf(this.csrf) + ", composerUrl=" + this.composerUrl + ", tenantId=" + this.tenantId + ", versioning=" + this.versioning + ")";
            }
        }
    }
}

