/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot;

import io.dialob.boot.DialobProgramExceptionHandlers;
import io.dialob.boot.controller.AdminController;
import io.dialob.boot.controller.ComposerController;
import io.dialob.boot.controller.FillController;
import io.dialob.boot.controller.GlobalModelAttributesInjector;
import io.dialob.boot.controller.PageSettingsProvider;
import io.dialob.boot.controller.ReviewController;
import io.dialob.boot.security.SecurityConfiguration;
import io.dialob.boot.settings.AdminApplicationSettings;
import io.dialob.boot.settings.ComposerApplicationSettings;
import io.dialob.boot.settings.QuestionnaireApplicationSettings;
import io.dialob.boot.settings.ReviewApplicationSettings;
import io.dialob.boot.settings.SettingsPageSettingsProvider;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import io.dialob.security.tenant.CurrentTenant;
import io.dialob.security.user.CurrentUserProvider;
import io.dialob.security.user.UnauthenticatedCurrentUserProvider;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.RestClientAuthorizationCodeTokenResponseClient;
import org.springframework.session.data.redis.config.ConfigureRedisAction;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.UrlTemplateResolver;

@Configuration(proxyBeanMethods=false)
@Import(value={SecurityConfiguration.class})
public class ApplicationAutoConfiguration {
    @Bean
    public OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> oauth2AccessTokenResponseClient() {
        return new RestClientAuthorizationCodeTokenResponseClient();
    }

    @Bean
    public DialobProgramExceptionHandlers dialobProgramExceptionHandlers() {
        return new DialobProgramExceptionHandlers();
    }

    @Bean
    public ConfigureRedisAction configureRedisAction() {
        return ConfigureRedisAction.NO_OP;
    }

    @Bean
    @ConditionalOnMissingBean(value={CurrentUserProvider.class})
    public CurrentUserProvider anonymousCurrentUserProvider() {
        return UnauthenticatedCurrentUserProvider.INSTANCE;
    }

    @Configuration(proxyBeanMethods=false)
    @Profile(value={"ui"})
    @Import(value={AdminController.class, FillController.class, ReviewController.class, ComposerController.class, GlobalModelAttributesInjector.class})
    @EnableConfigurationProperties(value={AdminApplicationSettings.class, ComposerApplicationSettings.class, QuestionnaireApplicationSettings.class, ReviewApplicationSettings.class})
    public static class UIConfiguration {
        @Bean
        public PageSettingsProvider settingsPageSettingsProvider(CurrentTenant currentTenant, QuestionnaireDatabase questionnaireDatabase, QuestionnaireApplicationSettings settings, ReviewApplicationSettings reviewSettings, Optional<AdminApplicationSettings> adminApplicationSettings, ComposerApplicationSettings composerApplicationSettings) {
            return new SettingsPageSettingsProvider(currentTenant, questionnaireDatabase, settings, reviewSettings, composerApplicationSettings, adminApplicationSettings);
        }

        @Configuration(proxyBeanMethods=false)
        public static class CustomWebMvcConfigurer
        implements WebMvcConfigurer {
            private final GlobalModelAttributesInjector globalModelAttributesInjector;
            private final SpringTemplateEngine springTemplateEngine;

            public CustomWebMvcConfigurer(GlobalModelAttributesInjector globalModelAttributesInjector, SpringTemplateEngine springTemplateEngine) {
                this.globalModelAttributesInjector = globalModelAttributesInjector;
                this.springTemplateEngine = springTemplateEngine;
            }

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor((HandlerInterceptor)this.globalModelAttributesInjector);
            }

            @PostConstruct
            public void templateEngine() {
                if (this.springTemplateEngine != null) {
                    UrlTemplateResolver urlTemplateResolver = new UrlTemplateResolver();
                    urlTemplateResolver.setOrder(Integer.valueOf(0));
                    urlTemplateResolver.setTemplateMode("HTML");
                    this.springTemplateEngine.addTemplateResolver((ITemplateResolver)urlTemplateResolver);
                }
            }
        }
    }
}

