/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.cli;

import io.devcon5.classutils.ClassStreams;
import io.devcon5.cli.CliOption;
import io.devcon5.cli.CliOptionGroup;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class OptionCollector {
    public Options collectFrom(Class type) {
        Options opts = new Options();
        this.collectOptions(type, opts);
        return opts;
    }

    private Class collectOptions(Class targetType, Options opts) {
        ClassStreams.selfAndSupertypes((Class)targetType).forEach(type -> {
            this.collectOptionFields((Class)type, opts);
            this.collectOptionGroup((Class)type, opts);
        });
        return targetType;
    }

    private void collectOptionGroup(Class targetType, Options opts) {
        Arrays.stream(targetType.getDeclaredFields()).filter(field -> field.getAnnotation(CliOptionGroup.class) != null).map(field -> field.getType()).forEach(fieldType -> this.collectOptions((Class)fieldType, opts));
    }

    private void collectOptionFields(Class targetType, Options opts) {
        Arrays.stream(targetType.getDeclaredFields()).map(field -> Optional.ofNullable(field.getAnnotation(CliOption.class))).filter(Optional::isPresent).map(opt -> this.toOption((CliOption)opt.get())).forEach(opt -> {
            if (opts.hasShortOption(opt.getOpt())) {
                throw new RuntimeException("Ambiguous short option definitions found for " + opt.getOpt());
            }
            if (opt.hasLongOpt() && opts.hasLongOption(opt.getLongOpt())) {
                throw new RuntimeException("Ambiguous long option definitions found for " + opt.getLongOpt());
            }
            opts.addOption(opt);
        });
    }

    private Option toOption(CliOption cliParam) {
        Option.Builder builder = Option.builder((String)cliParam.value()).hasArg(cliParam.hasArg()).required(cliParam.required());
        if (!cliParam.longOpt().isEmpty()) {
            builder.longOpt(cliParam.longOpt());
        }
        if (!cliParam.desc().isEmpty()) {
            builder.desc(cliParam.desc());
        }
        return builder.build();
    }
}

