/*
 * Decompiled with CFR 0.152.
 */
package decisionrules.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import decisionrules.DecisionRulesEnums;
import decisionrules.exceptions.DecisionRulesErrorException;
import java.net.URI;
import java.util.Arrays;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class Utils {
    static ObjectMapper mapper = new ObjectMapper();

    public static String getBaseURL(String host) {
        for (DecisionRulesEnums.HostEnum hostEnum : DecisionRulesEnums.HostEnum.values()) {
            if (!hostEnum.value.equalsIgnoreCase(host)) continue;
            switch (hostEnum) {
                case GLOBAL_CLOUD: {
                    return "https://api.decisionrules.io";
                }
                case REGION_EU: {
                    return "https://eu.api.decisionrules.io";
                }
                case REGION_US: {
                    return "https://us.api.decisionrules.io";
                }
                case REGION_AU: {
                    return "https://au.api.decisionrules.io";
                }
            }
            return "https://api.decisionrules.io";
        }
        return host;
    }

    public static HttpHeaders createHeaders(String key) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Solver key is not set.");
        }
        headers.set("Authorization", "Bearer " + key);
        return headers;
    }

    public static MappingJackson2HttpMessageConverter createConverter() {
        ObjectMapper objectMapper = new ObjectMapper();
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter(objectMapper);
        return converter;
    }

    public static DecisionRulesErrorException handleError(Exception e) {
        if (e.getMessage() != null && !e.getMessage().isEmpty()) {
            throw new DecisionRulesErrorException(e.getMessage(), Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).reduce("", (a, b) -> a + "\n" + b));
        }
        throw new DecisionRulesErrorException(String.format("Call ended with status:%s", e.getMessage()), Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).reduce("", (a, b) -> a + "\n" + b));
    }

    public static String doCall(RestTemplate restTemplate, URI url, HttpHeaders headers, HttpMethod method) {
        try {
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(url, method, entity, String.class);
            return (String)response.getBody();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static String doCall(RestTemplate restTemplate, URI url, HttpHeaders headers, HttpMethod method, Object body) {
        try {
            HttpEntity entity = new HttpEntity((Object)mapper.writeValueAsString(body), (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(url, method, entity, String.class);
            return (String)response.getBody();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }
}

