/*
 * Decompiled with CFR 0.152.
 */
package decisionrules.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import decisionrules.DecisionRulesOptions;
import decisionrules.model.SolverOptions;
import decisionrules.utils.Utils;
import java.net.URI;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class SolveApi {
    private final RestTemplate restTemplate;
    private final DecisionRulesOptions options;
    private final ObjectMapper mapper;

    public SolveApi(RestTemplate restTemplate, DecisionRulesOptions options, ObjectMapper mapper) {
        this.restTemplate = restTemplate;
        this.options = options;
        this.mapper = mapper;
    }

    public HttpHeaders createHeaders(String key, SolverOptions solverOptions) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Solver key is not set.");
        }
        headers.set("Authorization", "Bearer " + key);
        return headers;
    }

    private String createUrl(DecisionRulesOptions options, String ruleId, Integer version) throws Exception {
        Object url = String.format("/rule/solve/%s", ruleId);
        if (version != null && version > 0) {
            url = (String)url + String.valueOf(version);
        }
        return Utils.getBaseURL(options.host) + (String)url;
    }

    public String solveAPI(String ruleId, Object data, Integer version, SolverOptions solverOptions) {
        try {
            HttpEntity entity = new HttpEntity((Object)String.format("{ \"data\":  %s}", data instanceof String ? data : this.mapper.writeValueAsString(data)), (MultiValueMap)this.createHeaders(this.options.solverKey, solverOptions != null ? solverOptions : new SolverOptions(false, null, false, null)));
            ResponseEntity response = this.restTemplate.exchange(URI.create(this.createUrl(this.options, ruleId, version)), HttpMethod.POST, entity, String.class);
            return (String)response.getBody();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }
}

