/*
 * Decompiled with CFR 0.152.
 */
package decisionrules.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import decisionrules.DecisionRulesEnums;
import decisionrules.DecisionRulesOptions;
import decisionrules.model.Dependencies;
import decisionrules.model.Duplicates;
import decisionrules.model.FindOptions;
import decisionrules.model.FolderData;
import decisionrules.model.FolderExport;
import decisionrules.model.FolderImport;
import decisionrules.model.FolderNode;
import decisionrules.model.FolderOptions;
import decisionrules.model.Rule;
import decisionrules.model.RuleOptions;
import decisionrules.utils.Utils;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriUtils;

public class ManagementApi {
    private final RestTemplate restTemplate;
    private final ObjectMapper mapper;

    public ManagementApi(RestTemplate restTemplate, ObjectMapper mapper) {
        this.restTemplate = restTemplate;
        this.mapper = mapper;
    }

    public URI getCategoryUrl(String host, DecisionRulesEnums.MngCategoryEnum category, String[] apiPath, Map<String, String> queryParams) throws Exception {
        String baseUrl = Utils.getBaseURL(host);
        Object path = String.format("/api/%s/%s", category.value, String.join((CharSequence)"/", (CharSequence[])Arrays.stream(apiPath).filter(pathParam -> !pathParam.isEmpty()).toArray(String[]::new)));
        String queryString = queryParams.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> (String)entry.getKey() + "=" + String.valueOf(entry.getValue())).collect(Collectors.joining("&"));
        if (!queryString.isEmpty()) {
            path = (String)path + UriUtils.encodeQuery((String)("?" + queryString), (Charset)StandardCharsets.UTF_8);
        }
        return URI.create(baseUrl + (String)path);
    }

    public URI getCategoryUrl(String host, DecisionRulesEnums.MngCategoryEnum category, String[] apiPath, String[] queryParams) throws Exception {
        String baseUrl = Utils.getBaseURL(host);
        Object path = String.format("/api/%s/%s", category.value, String.join((CharSequence)"/", (CharSequence[])Arrays.stream(apiPath).filter(pathParam -> !pathParam.isEmpty()).toArray(String[]::new)));
        if (category == DecisionRulesEnums.MngCategoryEnum.TAGS) {
            if (queryParams.length > 0) {
                path = (String)path + UriUtils.encodeQuery((String)("/?tags=" + Arrays.stream(queryParams).map(tag -> tag.trim()).collect(Collectors.joining(","))), (Charset)StandardCharsets.UTF_8);
            }
            return URI.create(baseUrl + (String)path);
        }
        throw new Exception("This method can be used only for TAGS category.");
    }

    public URI getCategoryUrl(String host, DecisionRulesEnums.MngCategoryEnum category, String[] apiPath) throws Exception {
        try {
            String baseUrl = Utils.getBaseURL(host);
            String path = String.format("/api/%s/%s", category.value, String.join((CharSequence)"/", (CharSequence[])Arrays.stream(apiPath).filter(pathParam -> pathParam != null && !pathParam.isEmpty()).toArray(String[]::new)));
            return URI.create(baseUrl + path);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public Rule getRuleAPI(DecisionRulesOptions options, String ruleIdOrAlias, Integer version, RuleOptions ruleOptions) throws Exception {
        String versionString = this.getRuleVersion(version, ruleOptions);
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.RULE, new String[]{ruleIdOrAlias, versionString}, this.createDataMap(ruleOptions));
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.GET);
        return (Rule)this.mapper.readValue(response, Rule.class);
    }

    public Rule updateRuleStatusAPI(DecisionRulesOptions options, String ruleIdOrAlias, DecisionRulesEnums.RuleStatus status, Integer version) throws Exception {
        String versionString = this.getRuleVersion(version, null);
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.RULE, new String[]{"status", ruleIdOrAlias, status.value, versionString});
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.PUT);
        return (Rule)this.mapper.readValue(response, Rule.class);
    }

    public Rule updateRuleAPI(DecisionRulesOptions options, String ruleIdOrAlias, Rule data, Integer version) throws Exception {
        String versionString = this.getRuleVersion(version, null);
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.RULE, new String[]{ruleIdOrAlias, versionString});
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.PUT, data);
        return (Rule)this.mapper.readValue(response, Rule.class);
    }

    public Rule createRuleAPI(DecisionRulesOptions options, Object data, RuleOptions ruleOptions) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.RULE, new String[0], this.createDataMap(ruleOptions));
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.POST, data);
        return (Rule)this.mapper.readValue(response, Rule.class);
    }

    public Rule createNewRuleVersionAPI(DecisionRulesOptions options, String ruleIdOrAlias, Rule data) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.RULE, new String[]{ruleIdOrAlias, "new-version"});
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.POST, data);
        return (Rule)this.mapper.readValue(response, Rule.class);
    }

    public String deleteRuleAPI(DecisionRulesOptions options, String ruleIdOrAlias, Integer version, RuleOptions ruleOptions) throws Exception {
        String versionString = this.getRuleVersion(version, null);
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.RULE, new String[]{ruleIdOrAlias, versionString}, this.createDataMap(ruleOptions));
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.DELETE);
        return response;
    }

    public String lockRuleAPI(DecisionRulesOptions options, String ruleIdOrAlias, Boolean locked, Integer version, RuleOptions ruleOptions) throws Exception {
        String versionString = this.getRuleVersion(version, ruleOptions);
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.RULE, new String[]{"lock", ruleIdOrAlias, versionString}, this.createDataMap(ruleOptions));
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.PATCH, Map.of("locked", locked));
        return response;
    }

    public Duplicates findDuplicatesAPI(DecisionRulesOptions options, String ruleIdOrAlias, Integer version) throws Exception {
        String versionString = this.getRuleVersion(version, null);
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.TOOLS, new String[]{"duplicates", ruleIdOrAlias, versionString});
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.GET);
        return (Duplicates)this.mapper.readValue(response, Duplicates.class);
    }

    public Dependencies findDependenciesAPI(DecisionRulesOptions options, String ruleIdOrAlias, Integer version) throws Exception {
        String versionString = this.getRuleVersion(version, null);
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.TOOLS, new String[]{"dependencies", ruleIdOrAlias, versionString});
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.GET);
        return (Dependencies)this.mapper.readValue(response, Dependencies.class);
    }

    public Rule[] getRulesForSpaceAPI(DecisionRulesOptions options) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.SPACE, new String[]{"items"});
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.GET);
        return (Rule[])this.mapper.readValue(response, Rule[].class);
    }

    public Rule[] getRulesByTagsAPI(DecisionRulesOptions options, String[] tags) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.TAGS, new String[]{"items"}, tags);
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.GET);
        return (Rule[])this.mapper.readValue(response, Rule[].class);
    }

    public String[] addTagsAPI(DecisionRulesOptions options, String ruleIdOrAlias, String[] tags, Integer version) throws Exception {
        String versionString = this.getRuleVersion(version, null);
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.TAGS, new String[]{ruleIdOrAlias, versionString});
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.PATCH, tags);
        return (String[])this.mapper.readValue(response, String[].class);
    }

    public String deleteTagsAPI(DecisionRulesOptions options, String ruleIdOrAlias, String[] tags, Integer version) throws Exception {
        String versionString = this.getRuleVersion(version, null);
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.TAGS, new String[]{ruleIdOrAlias, versionString}, tags);
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.DELETE);
        return response;
    }

    public String createFolderAPI(DecisionRulesOptions options, String targetNodeId, FolderData data, FolderOptions folderOptions) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.FOLDER, new String[]{targetNodeId}, this.createDataMap(folderOptions));
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.POST, data);
        return response;
    }

    public FolderData updateNodeFolderStructureAPI(DecisionRulesOptions options, String targetNodeId, FolderData data, FolderOptions folderOptions) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.FOLDER, new String[]{targetNodeId}, this.createDataMap(folderOptions));
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.PUT, data);
        return (FolderData)this.mapper.readValue(response, FolderData.class);
    }

    public FolderExport exportFolderAPI(DecisionRulesOptions options, String targetNodeId, FolderOptions folderOptions) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.FOLDER, new String[]{"export", targetNodeId}, this.createDataMap(folderOptions));
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.GET);
        return (FolderExport)this.mapper.readValue(response, FolderExport.class);
    }

    public FolderImport importFolderAPI(DecisionRulesOptions options, String targetNodeId, Object data, FolderOptions folderOptions) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.FOLDER, new String[]{"import", targetNodeId}, this.createDataMap(folderOptions));
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.POST, data);
        return (FolderImport)this.mapper.readValue(response, FolderImport.class);
    }

    public FolderData getFolderStructureAPI(DecisionRulesOptions options, String targetNodeId, FolderOptions folderOptions) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.FOLDER, new String[]{targetNodeId}, this.createDataMap(folderOptions));
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.GET);
        return (FolderData)this.mapper.readValue(response, FolderData.class);
    }

    public String deleteFolderAPI(DecisionRulesOptions options, String targetNodeId, Boolean deleteAll, FolderOptions folderOptions) throws Exception {
        HashMap<String, String> folderOptionsMap = new HashMap<String, String>(this.createDataMap(folderOptions));
        folderOptionsMap.put("deleteAll", deleteAll.toString());
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.FOLDER, new String[]{targetNodeId}, folderOptionsMap);
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.DELETE);
        return response;
    }

    public String renameFolderAPI(DecisionRulesOptions options, String targetNodeId, String name, FolderOptions folderOptions) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.FOLDER, new String[]{"rename", targetNodeId}, this.createDataMap(folderOptions));
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.PATCH, Map.of("name", name));
        return response;
    }

    public String moveFolderAPI(DecisionRulesOptions options, String targetNodeId, FolderNode[] nodes, String targetPath) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.FOLDER, new String[]{"move"});
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.PUT, targetPath != null ? Map.of("nodes", nodes, "targetPath", targetPath) : Map.of("nodes", nodes, "targetPath", targetNodeId));
        return response;
    }

    public String findFolderOrRuleByAttributeAPI(DecisionRulesOptions options, FindOptions findOptions) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.managementKey);
        URI url = this.getCategoryUrl(options.host, DecisionRulesEnums.MngCategoryEnum.FOLDER, new String[]{"find"});
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.POST, findOptions);
        return response;
    }

    String getRuleVersion(Integer version, RuleOptions ruleOptions) {
        if (ruleOptions != null && ruleOptions.version != null) {
            return "";
        }
        return version != null ? Integer.toString(version) : "";
    }

    Map<String, String> createDataMap(Object data) {
        if (data != null) {
            return (Map)this.mapper.convertValue(data, Map.class);
        }
        return Collections.emptyMap();
    }
}

