/*
 * Decompiled with CFR 0.152.
 */
package decisionrules.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import decisionrules.DecisionRulesOptions;
import decisionrules.model.Job;
import decisionrules.utils.Utils;
import java.net.URI;
import java.util.Arrays;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;

public class JobApi {
    private final RestTemplate restTemplate;
    private final ObjectMapper mapper;

    public JobApi(RestTemplate restTemplate, ObjectMapper mapper) {
        this.restTemplate = restTemplate;
        this.mapper = mapper;
    }

    public URI getCategoryUrl(String host, String[] apiPath) throws Exception {
        try {
            String baseUrl = Utils.getBaseURL(host);
            String path = String.format("/job/%s", String.join((CharSequence)"/", (CharSequence[])Arrays.stream(apiPath).filter(pathParam -> pathParam != null && !pathParam.isEmpty()).toArray(String[]::new)));
            return URI.create(baseUrl + path);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public Job startJobAPI(DecisionRulesOptions options, String ruleIdOrAlias, Object inputData, Integer version) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.solverKey);
        URI url = this.getCategoryUrl(options.host, new String[]{"start", ruleIdOrAlias, version != null ? Integer.toString(version) : ""});
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.POST, inputData);
        return (Job)this.mapper.readValue(response, Job.class);
    }

    public Job cancelJobAPI(DecisionRulesOptions options, String jobId) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.solverKey);
        URI url = this.getCategoryUrl(options.host, new String[]{"cancel", jobId});
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.POST);
        return (Job)this.mapper.readValue(response, Job.class);
    }

    public Job jobInfoAPI(DecisionRulesOptions options, String jobId) throws Exception {
        HttpHeaders headers = Utils.createHeaders(options.solverKey);
        URI url = this.getCategoryUrl(options.host, new String[]{jobId});
        String response = Utils.doCall(this.restTemplate, url, headers, HttpMethod.GET);
        return (Job)this.mapper.readValue(response, Job.class);
    }
}

