/*
 * Decompiled with CFR 0.152.
 */
package decisionrules;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import decisionrules.DecisionRulesEnums;
import decisionrules.DecisionRulesOptions;
import decisionrules.api.JobApi;
import decisionrules.api.ManagementApi;
import decisionrules.api.SolveApi;
import decisionrules.model.Dependencies;
import decisionrules.model.Duplicates;
import decisionrules.model.FindOptions;
import decisionrules.model.FolderData;
import decisionrules.model.FolderExport;
import decisionrules.model.FolderImport;
import decisionrules.model.FolderNode;
import decisionrules.model.FolderOptions;
import decisionrules.model.Rule;
import decisionrules.model.RuleOptions;
import decisionrules.model.SolverOptions;
import decisionrules.utils.Utils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class DecisionRulesService {
    public final Management management = new Management();
    public final Job job = new Job();
    private final RestTemplate restTemplate;
    private final DecisionRulesOptions options;
    private final ObjectMapper mapper = new ObjectMapper();
    private final SolveApi solveApi;
    private final ManagementApi managementApi;
    private final JobApi jobApi;

    public DecisionRulesService(DecisionRulesOptions options) {
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)HttpClients.createDefault()));
        this.restTemplate.getMessageConverters().add(Utils.createConverter());
        this.options = options;
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.solveApi = new SolveApi(this.restTemplate, this.options, this.mapper);
        this.managementApi = new ManagementApi(this.restTemplate, this.mapper);
        this.jobApi = new JobApi(this.restTemplate, this.mapper);
    }

    public String solve(String ruleIdOrAlias, Object input) {
        return this.solveApi.solveAPI(ruleIdOrAlias, input, -1, null);
    }

    public String solve(String ruleIdOrAlias, Object input, Integer version) {
        return this.solveApi.solveAPI(ruleIdOrAlias, input, version, null);
    }

    public String solve(String ruleIdOrAlias, Object input, Integer version, SolverOptions solverOptions) {
        return this.solveApi.solveAPI(ruleIdOrAlias, input, version, solverOptions);
    }

    public boolean validateWebhookSignature(String payload, String signature, String secret) {
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            hmac.init(secretKey);
            byte[] hash = hmac.doFinal(payload.getBytes(StandardCharsets.UTF_8));
            String expectedSignature = this.bytesToHex(hash);
            return MessageDigest.isEqual(signature.getBytes(StandardCharsets.UTF_8), expectedSignature.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw Utils.handleError(e);
        }
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public class Management {
        public Rule getRule(String ruleIdOrAlias, Integer version) {
            try {
                return DecisionRulesService.this.managementApi.getRuleAPI(DecisionRulesService.this.options, ruleIdOrAlias, version, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Rule getRule(String ruleIdOrAlias) {
            try {
                return DecisionRulesService.this.managementApi.getRuleAPI(DecisionRulesService.this.options, ruleIdOrAlias, null, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Rule getRuleByPath(String path, Integer version) {
            try {
                return DecisionRulesService.this.managementApi.getRuleAPI(DecisionRulesService.this.options, "", version, new RuleOptions(path, version));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Rule getRuleByPath(String path) {
            try {
                return DecisionRulesService.this.managementApi.getRuleAPI(DecisionRulesService.this.options, "", null, new RuleOptions(path, null));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Rule updateRuleStatus(String ruleIdOrAlias, DecisionRulesEnums.RuleStatus status, Integer version) {
            try {
                return DecisionRulesService.this.managementApi.updateRuleStatusAPI(DecisionRulesService.this.options, ruleIdOrAlias, status, version);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Rule updateRule(String ruleIdOrAlias, Rule rule, Integer version) {
            try {
                return DecisionRulesService.this.managementApi.updateRuleAPI(DecisionRulesService.this.options, ruleIdOrAlias, rule, version);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Rule updateRule(String ruleIdOrAlias, Rule rule) {
            try {
                return DecisionRulesService.this.managementApi.updateRuleAPI(DecisionRulesService.this.options, ruleIdOrAlias, rule, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Rule createRule(Rule rule, String path) {
            try {
                return DecisionRulesService.this.managementApi.createRuleAPI(DecisionRulesService.this.options, rule, new RuleOptions(path, null));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Rule createRule(Rule rule) {
            try {
                return this.createRule(rule, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Rule createNewRuleVersion(String ruleIdOrAlias, Rule rule) {
            try {
                return DecisionRulesService.this.managementApi.createNewRuleVersionAPI(DecisionRulesService.this.options, ruleIdOrAlias, rule);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void deleteRule(String ruleIdOrAlias, Integer version) {
            try {
                DecisionRulesService.this.managementApi.deleteRuleAPI(DecisionRulesService.this.options, ruleIdOrAlias, version, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void deleteRule(String ruleIdOrAlias) {
            try {
                this.deleteRule(ruleIdOrAlias, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void deleteRuleByPath(String path, Integer version) {
            try {
                DecisionRulesService.this.managementApi.deleteRuleAPI(DecisionRulesService.this.options, "", null, new RuleOptions(path, version));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void deleteRuleByPath(String path) {
            try {
                this.deleteRuleByPath(path, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void lockRule(String ruleIdOrAlias, boolean lock, Integer version) {
            try {
                DecisionRulesService.this.managementApi.lockRuleAPI(DecisionRulesService.this.options, ruleIdOrAlias, lock, version, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void lockRule(String ruleIdOrAlias, boolean lock) {
            try {
                DecisionRulesService.this.managementApi.lockRuleAPI(DecisionRulesService.this.options, ruleIdOrAlias, lock, null, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void lockRuleByPath(String path, boolean lock, Integer version) {
            try {
                DecisionRulesService.this.managementApi.lockRuleAPI(DecisionRulesService.this.options, "", lock, version, new RuleOptions(path, version));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void lockRuleByPath(String path, boolean lock) {
            try {
                DecisionRulesService.this.managementApi.lockRuleAPI(DecisionRulesService.this.options, "", lock, null, new RuleOptions(path, null));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Duplicates findDuplicates(String ruleIdOrAlias, Integer version) {
            try {
                return DecisionRulesService.this.managementApi.findDuplicatesAPI(DecisionRulesService.this.options, ruleIdOrAlias, version);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Duplicates findDuplicates(String ruleIdOrAlias) {
            try {
                return DecisionRulesService.this.managementApi.findDuplicatesAPI(DecisionRulesService.this.options, ruleIdOrAlias, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Dependencies findDependencies(String ruleIdOrAlias, Integer version) {
            try {
                return DecisionRulesService.this.managementApi.findDependenciesAPI(DecisionRulesService.this.options, ruleIdOrAlias, version);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Dependencies findDependencies(String ruleIdOrAlias) {
            try {
                return DecisionRulesService.this.managementApi.findDependenciesAPI(DecisionRulesService.this.options, ruleIdOrAlias, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Rule[] getRulesForSpace() {
            try {
                return DecisionRulesService.this.managementApi.getRulesForSpaceAPI(DecisionRulesService.this.options);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public Rule[] getRulesByTags(String[] tags) {
            try {
                return DecisionRulesService.this.managementApi.getRulesByTagsAPI(DecisionRulesService.this.options, tags);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public String[] updateTags(String ruleIdOrAlias, String[] tags, Integer version) {
            try {
                return DecisionRulesService.this.managementApi.addTagsAPI(DecisionRulesService.this.options, ruleIdOrAlias, tags, version);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public String[] updateTags(String ruleIdOrAlias, String[] tags) {
            try {
                return DecisionRulesService.this.managementApi.addTagsAPI(DecisionRulesService.this.options, ruleIdOrAlias, tags, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void deleteTags(String ruleIdOrAlias, String[] tags, Integer version) {
            try {
                DecisionRulesService.this.managementApi.deleteTagsAPI(DecisionRulesService.this.options, ruleIdOrAlias, tags, version);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void deleteTags(String ruleIdOrAlias, String[] tags) {
            try {
                DecisionRulesService.this.managementApi.deleteTagsAPI(DecisionRulesService.this.options, ruleIdOrAlias, tags, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void createFolder(String targetNodeid, FolderData data) {
            try {
                DecisionRulesService.this.managementApi.createFolderAPI(DecisionRulesService.this.options, targetNodeid, data, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void createFolderByPath(String path, FolderData data) {
            try {
                DecisionRulesService.this.managementApi.createFolderAPI(DecisionRulesService.this.options, "", data, new FolderOptions(path));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public FolderData updateNodeFolderStructure(String targetNodeid, FolderData data) {
            try {
                return DecisionRulesService.this.managementApi.updateNodeFolderStructureAPI(DecisionRulesService.this.options, targetNodeid, data, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public FolderData updateNodeFolderStructureByPath(String path, FolderData data) {
            try {
                return DecisionRulesService.this.managementApi.updateNodeFolderStructureAPI(DecisionRulesService.this.options, "", data, new FolderOptions(path));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public FolderExport exportFolder(String nodeId) {
            try {
                return DecisionRulesService.this.managementApi.exportFolderAPI(DecisionRulesService.this.options, nodeId, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public FolderExport exportFolderByPath(String path) {
            try {
                return DecisionRulesService.this.managementApi.exportFolderAPI(DecisionRulesService.this.options, "", new FolderOptions(path));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public FolderImport importFolder(String targetNodeid, Object data) {
            try {
                return DecisionRulesService.this.managementApi.importFolderAPI(DecisionRulesService.this.options, targetNodeid, data, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public FolderImport importFolderToPath(String path, Object data) {
            try {
                return DecisionRulesService.this.managementApi.importFolderAPI(DecisionRulesService.this.options, "", data, new FolderOptions(path));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public FolderData getFolderStructure(String targetNodeid) {
            try {
                return DecisionRulesService.this.managementApi.getFolderStructureAPI(DecisionRulesService.this.options, targetNodeid, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public FolderData getFolderStructure() {
            try {
                return DecisionRulesService.this.managementApi.getFolderStructureAPI(DecisionRulesService.this.options, "", null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public FolderData getFolderStructureByPath(String path) {
            try {
                return DecisionRulesService.this.managementApi.getFolderStructureAPI(DecisionRulesService.this.options, null, new FolderOptions(path));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void deleteFolder(String targetNodeid, boolean deleteAll) {
            try {
                DecisionRulesService.this.managementApi.deleteFolderAPI(DecisionRulesService.this.options, targetNodeid, deleteAll, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void deleteFolderByPath(String path, boolean deleteAll) {
            try {
                DecisionRulesService.this.managementApi.deleteFolderAPI(DecisionRulesService.this.options, "", deleteAll, new FolderOptions(path));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void renameFolder(String targetNodeid, String newName) {
            try {
                DecisionRulesService.this.managementApi.renameFolderAPI(DecisionRulesService.this.options, targetNodeid, newName, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void renameFolderByPath(String path, String newName) {
            try {
                DecisionRulesService.this.managementApi.renameFolderAPI(DecisionRulesService.this.options, "", newName, new FolderOptions(path));
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public void moveFolder(String targetId, FolderNode[] nodes, String targetPath) {
            try {
                DecisionRulesService.this.managementApi.moveFolderAPI(DecisionRulesService.this.options, targetId, nodes, targetPath);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public String findFolderOrRuleByAttribute(FindOptions data) {
            try {
                return DecisionRulesService.this.managementApi.findFolderOrRuleByAttributeAPI(DecisionRulesService.this.options, data);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }
    }

    public class Job {
        public decisionrules.model.Job start(String ruleIdOrAlias, Object inputData, Integer version) {
            try {
                return DecisionRulesService.this.jobApi.startJobAPI(DecisionRulesService.this.options, ruleIdOrAlias, inputData, version);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public decisionrules.model.Job start(String ruleIdOrAlias, Object inputData) {
            try {
                return DecisionRulesService.this.jobApi.startJobAPI(DecisionRulesService.this.options, ruleIdOrAlias, inputData, null);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public decisionrules.model.Job cancel(String jobId) {
            try {
                return DecisionRulesService.this.jobApi.cancelJobAPI(DecisionRulesService.this.options, jobId);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }

        public decisionrules.model.Job info(String jobId) {
            try {
                return DecisionRulesService.this.jobApi.jobInfoAPI(DecisionRulesService.this.options, jobId);
            }
            catch (Exception e) {
                throw Utils.handleError(e);
            }
        }
    }
}

