/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerConfig;
import io.debezium.testing.testcontainers.Connector;
import io.debezium.testing.testcontainers.ConnectorConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.node.ObjectNode;

public class ConnectorConfigurationTest {
    private ObjectMapper mapper = new ObjectMapper();

    @Test
    public void shouldSerializeConnectorConfiguration() throws IOException {
        ConnectorConfiguration configuration = ConnectorConfiguration.create();
        configuration.with("connector.class", "foo");
        configuration.with("database.hostname", "bar");
        Connector connector = Connector.from((String)"myconnector", (ConnectorConfiguration)configuration);
        String json = connector.toJson();
        ObjectNode connectionNode = (ObjectNode)this.mapper.readValue(json, ObjectNode.class);
        Assertions.assertThat((String)connectionNode.get("name").asText()).isEqualTo((Object)"myconnector");
        JsonNode configNode = connectionNode.get("config");
        Assertions.assertThat((String)configNode.get("connector.class").asText()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)configNode.get("database.hostname").asText()).isEqualTo((Object)"bar");
    }

    @Test
    public void shouldLoadConnectorConfigurationFromFile() throws IOException {
        InputStream configFile = ConnectorConfigurationTest.class.getClassLoader().getResourceAsStream("config.json");
        Connector connector = Connector.fromJson((InputStream)configFile);
        String json = connector.toJson();
        ObjectNode connectionNode = (ObjectNode)this.mapper.readValue(json, ObjectNode.class);
        Assertions.assertThat((String)connectionNode.get("name").asText()).isEqualTo((Object)"inventory-connector");
        JsonNode configNode = connectionNode.get("config");
        Assertions.assertThat((String)configNode.get("connector.class").asText()).isEqualTo((Object)"io.debezium.connector.mysql.MySqlConnector");
        Assertions.assertThat((String)configNode.get("database.hostname").asText()).isEqualTo((Object)"192.168.99.100");
    }

    @Test
    public void shouldOverrideConfigurationFromJdbcContainer() throws IOException {
        ContainerConfig containerConfig = (ContainerConfig)Mockito.mock(ContainerConfig.class);
        Mockito.when((Object)containerConfig.getHostName()).thenReturn((Object)"localhost");
        InspectContainerResponse inspectContainerResponse = (InspectContainerResponse)Mockito.mock(InspectContainerResponse.class);
        Mockito.when((Object)inspectContainerResponse.getConfig()).thenReturn((Object)containerConfig);
        JdbcDatabaseContainer jdbcDatabaseContainer = (JdbcDatabaseContainer)Mockito.mock(JdbcDatabaseContainer.class);
        Mockito.when((Object)jdbcDatabaseContainer.getDriverClassName()).thenReturn((Object)"org.postgresql.Driver");
        Mockito.when((Object)jdbcDatabaseContainer.getDatabaseName()).thenReturn((Object)"db");
        Mockito.when((Object)jdbcDatabaseContainer.getPassword()).thenReturn((Object)"");
        Mockito.when((Object)jdbcDatabaseContainer.getUsername()).thenReturn((Object)"");
        Mockito.when((Object)jdbcDatabaseContainer.getExposedPorts()).thenReturn(Arrays.asList(9090));
        Mockito.when((Object)jdbcDatabaseContainer.getContainerInfo()).thenReturn((Object)inspectContainerResponse);
        InputStream configFile = ConnectorConfigurationTest.class.getClassLoader().getResourceAsStream("config.json");
        Connector connector = Connector.fromJson((InputStream)configFile);
        connector.appendOrOverrideConfiguration(ConnectorConfiguration.forJdbcContainer((JdbcDatabaseContainer)jdbcDatabaseContainer));
        String json = connector.toJson();
        ObjectNode connectionNode = (ObjectNode)this.mapper.readValue(json, ObjectNode.class);
        Assertions.assertThat((String)connectionNode.get("name").asText()).isEqualTo((Object)"inventory-connector");
        JsonNode configNode = connectionNode.get("config");
        Assertions.assertThat((String)configNode.get("connector.class").asText()).isEqualTo((Object)"io.debezium.connector.postgresql.PostgresConnector");
        Assertions.assertThat((String)configNode.get("database.hostname").asText()).isEqualTo((Object)"localhost");
        Assertions.assertThat((String)configNode.get("database.dbname").asText()).isEqualTo((Object)"db");
    }
}

