/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.secretweb.web;

import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.scanner.Scanner;
import io.datarouter.secret.config.SecretClientConfig;
import io.datarouter.secret.op.SecretOpReason;
import io.datarouter.secret.op.SecretOpType;
import io.datarouter.secret.service.SecretService;
import io.datarouter.secretweb.config.DatarouterSecretFiles;
import io.datarouter.secretweb.config.DatarouterSecretPaths;
import io.datarouter.secretweb.service.WebSecretOpReason;
import io.datarouter.secretweb.web.SecretClientSupplierConfigDto;
import io.datarouter.secretweb.web.SecretHandlerOpRequestDto;
import io.datarouter.secretweb.web.SecretHandlerOpResultDto;
import io.datarouter.secretweb.web.SecretHandlerPermissions;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.RequestBody;
import io.datarouter.web.html.react.bootstrap4.Bootstrap4ReactPageFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(SecretHandler.class);
    @Inject
    private DatarouterSecretFiles files;
    @Inject
    private DatarouterSecretPaths paths;
    @Inject
    private SecretHandlerPermissions permissions;
    @Inject
    private SecretService secretService;
    @Inject
    private Bootstrap4ReactPageFactory reactPageFactory;
    @Inject
    private ChangelogRecorder changelogRecorder;

    @BaseHandler.Handler(defaultHandler=true)
    private Mav index() {
        return this.reactPageFactory.startBuilder(this.request).withTitle("Datarouter - Secrets").withReactScript(this.files.js.secretsJsx).withJsStringConstant("PATH_HANDLE", String.valueOf(this.request.getContextPath()) + this.paths.datarouter.secrets.handle.toSlashedString()).withJsStringConstant("PATH_CONFIG", String.valueOf(this.request.getContextPath()) + this.paths.datarouter.secrets.getSecretClientSupplierConfig.toSlashedString()).buildMav();
    }

    @BaseHandler.Handler
    public SecretClientSupplierConfigDto.SecretClientSupplierConfigsDto getSecretClientSupplierConfig() {
        List secretClientSupplierConfigs = this.secretService.getSecretClientSupplierConfigs();
        List orderedConfigs = Scanner.of((Iterable)secretClientSupplierConfigs).map(SecretClientConfig::getConfigName).list();
        return new SecretClientSupplierConfigDto.SecretClientSupplierConfigsDto(orderedConfigs, Scanner.of((Iterable)secretClientSupplierConfigs).map(config -> new SecretClientSupplierConfigDto(config.getConfigName(), config.getSecretClientSupplierClass().getSimpleName(), this.buildAllowedOps(config.getAllowedOps()), config.getAllowedNames().isPresent() ? Scanner.of((Iterable)((Iterable)config.getAllowedNames().get())).toMap() : Map.of())).toMap(dto -> dto.configName));
    }

    @BaseHandler.Handler
    public SecretHandlerOpResultDto handle(@RequestBody SecretHandlerOpRequestDto requestDto) {
        SecretHandlerOpResultDto result = this.validateRequest(requestDto);
        if (result == null) {
            result = this.executeAuthorizedRequest(requestDto);
            if (requestDto.op != SecretHandlerOpRequestDto.SecretOpDto.LIST_ALL) {
                this.changelogRecorder.record("Secrets", requestDto.name, requestDto.op.getPersistentString(), this.getSessionInfo().getNonEmptyUsernameOrElse(""));
            }
        }
        return result;
    }

    private Map<SecretHandlerOpRequestDto.SecretOpDto, SecretHandlerOpRequestDto.SecretOpDto> buildAllowedOps(Set<SecretOpType> serviceOps) {
        HashSet<SecretHandlerOpRequestDto.SecretOpDto> allowedOps = new HashSet<SecretHandlerOpRequestDto.SecretOpDto>();
        if (serviceOps.contains(SecretOpType.CREATE) || serviceOps.contains(SecretOpType.PUT)) {
            allowedOps.add(SecretHandlerOpRequestDto.SecretOpDto.CREATE);
        }
        if (serviceOps.contains(SecretOpType.READ)) {
            allowedOps.add(SecretHandlerOpRequestDto.SecretOpDto.READ);
        }
        if (serviceOps.contains(SecretOpType.UPDATE) || serviceOps.contains(SecretOpType.PUT)) {
            allowedOps.add(SecretHandlerOpRequestDto.SecretOpDto.UPDATE);
        }
        if (serviceOps.contains(SecretOpType.DELETE)) {
            allowedOps.add(SecretHandlerOpRequestDto.SecretOpDto.DELETE);
        }
        if (serviceOps.contains(SecretOpType.LIST)) {
            allowedOps.add(SecretHandlerOpRequestDto.SecretOpDto.LIST_ALL);
        }
        return Scanner.of(allowedOps).toMap();
    }

    private SecretHandlerOpResultDto validateRequest(SecretHandlerOpRequestDto requestDto) {
        if (requestDto.op == null) {
            return SecretHandlerOpResultDto.error("Op is required.");
        }
        switch (requestDto.op) {
            case CREATE: {
                if (StringTool.isNullOrEmptyOrWhitespace((String)requestDto.secretClass)) {
                    return SecretHandlerOpResultDto.error("SecretClass is required for this op.");
                }
            }
            case UPDATE: {
                if (StringTool.isNullOrEmptyOrWhitespace((String)requestDto.name)) {
                    return SecretHandlerOpResultDto.error("Name is required for this op.");
                }
                if (!StringTool.isNullOrEmptyOrWhitespace((String)requestDto.value)) break;
                return SecretHandlerOpResultDto.error("Value is required for this op.");
            }
            case READ: 
            case DELETE: {
                if (!StringTool.isNullOrEmptyOrWhitespace((String)requestDto.name)) break;
                return SecretHandlerOpResultDto.error("Name is required for this op.");
            }
            case LIST_ALL: {
                break;
            }
            default: {
                return SecretHandlerOpResultDto.error("Unknown op.");
            }
        }
        if (!this.permissions.isAuthorized(this.getSessionInfo().getRequiredSession(), requestDto.op)) {
            return SecretHandlerOpResultDto.denied("Permission denied for " + (Object)((Object)requestDto.op) + " op.");
        }
        return null;
    }

    private SecretHandlerOpResultDto executeAuthorizedRequest(SecretHandlerOpRequestDto requestDto) {
        try {
            SecretOpReason opReason = WebSecretOpReason.manualOp(this.getSessionInfo().getRequiredSession(), "SecretHandler");
            Optional configName = StringTool.isEmptyOrWhitespace((String)requestDto.configName) ? Optional.empty() : Optional.ofNullable(requestDto.configName);
            switch (requestDto.op) {
                case CREATE: {
                    try {
                        this.secretService.create(configName, requestDto.name, requestDto.value, Class.forName(requestDto.secretClass), opReason);
                    }
                    catch (ClassNotFoundException e) {
                        return SecretHandlerOpResultDto.error("Provided class cannot be found.");
                    }
                    return SecretHandlerOpResultDto.success();
                }
                case UPDATE: {
                    this.secretService.updateRaw(configName, requestDto.name, requestDto.value, opReason);
                    return SecretHandlerOpResultDto.success();
                }
                case READ: {
                    return SecretHandlerOpResultDto.read(this.secretService.readRaw(configName, requestDto.name, opReason));
                }
                case DELETE: {
                    this.secretService.delete(configName, requestDto.name, opReason);
                    return SecretHandlerOpResultDto.success();
                }
                case LIST_ALL: {
                    List appNames = this.secretService.listSecretNames(configName, opReason);
                    appNames.sort(String.CASE_INSENSITIVE_ORDER);
                    List sharedNames = this.secretService.listSecretNamesShared(configName, opReason);
                    sharedNames.sort(String.CASE_INSENSITIVE_ORDER);
                    return SecretHandlerOpResultDto.list(appNames, sharedNames);
                }
            }
            return SecretHandlerOpResultDto.error("Unknown op.");
        }
        catch (RuntimeException e) {
            logger.warn("Failed SecretHandler operation: ", (Throwable)e);
            return SecretHandlerOpResultDto.error(e.getMessage());
        }
    }
}

