/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.AdvanceUntilScanner;
import io.datarouter.scanner.AdvanceWhileScanner;
import io.datarouter.scanner.ArrayScanner;
import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.BatchingScanner;
import io.datarouter.scanner.CollatingScanner;
import io.datarouter.scanner.ConcatenatingScanner;
import io.datarouter.scanner.DeduplicatingConsecutiveScanner;
import io.datarouter.scanner.DistinctScanner;
import io.datarouter.scanner.EachScanner;
import io.datarouter.scanner.EmptyScanner;
import io.datarouter.scanner.FilteringScanner;
import io.datarouter.scanner.GeneratingScanner;
import io.datarouter.scanner.IterableScanner;
import io.datarouter.scanner.IteratingScanner;
import io.datarouter.scanner.IteratorScanner;
import io.datarouter.scanner.LimitingScanner;
import io.datarouter.scanner.MappingScanner;
import io.datarouter.scanner.NaturalSortingScanner;
import io.datarouter.scanner.ObjectScanner;
import io.datarouter.scanner.ParallelScanner;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.PrefetchingScanner;
import io.datarouter.scanner.RetainingGroup;
import io.datarouter.scanner.RetainingScanner;
import io.datarouter.scanner.ReverseListScanner;
import io.datarouter.scanner.SamplingScanner;
import io.datarouter.scanner.ScannerIterator;
import io.datarouter.scanner.ScannerStream;
import io.datarouter.scanner.ScannerToGroups;
import io.datarouter.scanner.ScannerToMap;
import io.datarouter.scanner.ScannerTool;
import io.datarouter.scanner.ShufflingScanner;
import io.datarouter.scanner.SortingScanner;
import io.datarouter.scanner.SplittingScanner;
import io.datarouter.scanner.StreamScanner;
import java.io.Closeable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public interface Scanner<T>
extends Closeable {
    public boolean advance();

    public T current();

    @Override
    default public void close() {
    }

    default public void forEach(Consumer<? super T> action) {
        ScannerTool.forEach(this, action);
    }

    default public List<T> take(int numToTake) {
        return ScannerTool.take(this, numToTake);
    }

    public static <T> Scanner<T> empty() {
        return EmptyScanner.singleton();
    }

    public static <T> Scanner<T> generate(Supplier<T> supplier) {
        return new GeneratingScanner<T>(supplier);
    }

    public static <T> Scanner<T> iterate(T seed, UnaryOperator<T> unaryOperator) {
        return new IteratingScanner<T>(seed, unaryOperator);
    }

    public static <T> Scanner<T> ofNullable(T object) {
        return ObjectScanner.ofNullable(object);
    }

    public static <T> Scanner<T> of(T object) {
        return ObjectScanner.of(object);
    }

    @SafeVarargs
    public static <T> Scanner<T> of(T ... array) {
        return ArrayScanner.of(array);
    }

    public static <T> Scanner<T> of(Iterator<T> iterator) {
        return IteratorScanner.of(iterator);
    }

    public static <T> Scanner<T> of(Iterable<T> iterable) {
        return IterableScanner.of(iterable);
    }

    public static <T> Scanner<T> of(Stream<T> stream) {
        return StreamScanner.of(stream);
    }

    default public <R> Scanner<R> concatIter(Function<? super T, Iterable<R>> mapToIterable) {
        Scanner<Iterable<Scanner>> iterables = this.map(mapToIterable);
        Scanner scanners = iterables.map(IterableScanner::of);
        return new ConcatenatingScanner(scanners);
    }

    default public <R> Scanner<R> concat(Function<? super T, Scanner<R>> mapToScanner) {
        Scanner scanners = this.map(mapToScanner);
        return new ConcatenatingScanner(scanners);
    }

    @SafeVarargs
    public static <T> Scanner<T> concat(Scanner<T> ... scanners) {
        return Scanner.of(scanners).concat(Function.identity());
    }

    @SafeVarargs
    public static <T> Scanner<T> concat(Iterable<T> ... iterables) {
        return Scanner.of(iterables).concat(Scanner::of);
    }

    default public Scanner<T> append(Scanner<T> scanner) {
        return Scanner.concat(this, scanner);
    }

    default public Scanner<T> append(T ... items) {
        return Scanner.concat(this, Scanner.of(items));
    }

    default public Scanner<T> append(Iterable<T> iterable) {
        return Scanner.concat(this, Scanner.of(iterable));
    }

    default public <R> Scanner<R> collate(Function<? super T, Scanner<R>> mapper) {
        return this.collate(mapper, Comparator.naturalOrder());
    }

    default public <R> Scanner<R> collate(Function<? super T, Scanner<R>> mapper, Comparator<? super R> comparator) {
        List scanners = this.map(mapper).list();
        if (scanners.size() == 1) {
            return scanners.get(0);
        }
        return new CollatingScanner<R>(scanners, comparator);
    }

    default public <R> Scanner<R> link(Function<Scanner<T>, BaseLinkedScanner<T, R>> scannerBuilder) {
        return scannerBuilder.apply(this);
    }

    default public <R> R apply(Function<Scanner<T>, R> function) {
        return function.apply(this);
    }

    default public void then(Consumer<Scanner<T>> consumer) {
        consumer.accept(this);
    }

    default public ParallelScanner<T> parallel(ParallelScannerContext context) {
        return new ParallelScanner(context, this);
    }

    default public Scanner<T> prefetch(ExecutorService exec, int batchSize) {
        return new PrefetchingScanner<List>(this, exec, batchSize).concat(Scanner::of);
    }

    default public Scanner<T> advanceUntil(Predicate<? super T> predicate) {
        return new AdvanceUntilScanner<T>(this, predicate);
    }

    default public Scanner<T> advanceWhile(Predicate<? super T> predicate) {
        return new AdvanceWhileScanner<T>(this, predicate);
    }

    default public Scanner<List<T>> batch(int batchSize) {
        return new BatchingScanner(this, batchSize);
    }

    default public Scanner<T> deduplicateConsecutive() {
        return new DeduplicatingConsecutiveScanner(this, Function.identity());
    }

    default public Scanner<T> deduplicateConsecutiveBy(Function<T, ?> mapper) {
        return new DeduplicatingConsecutiveScanner(this, mapper);
    }

    default public Scanner<T> each(Consumer<? super T> consumer) {
        return new EachScanner<T>(this, consumer);
    }

    default public Scanner<T> exclude(Predicate<? super T> predicate) {
        return new FilteringScanner<T>(this, predicate.negate());
    }

    default public Scanner<T> include(Predicate<? super T> predicate) {
        return new FilteringScanner<T>(this, predicate);
    }

    default public Scanner<T> limit(long limit) {
        return new LimitingScanner(this, limit);
    }

    default public <R> Scanner<R> map(Function<? super T, ? extends R> mapper) {
        return new MappingScanner<T, R>(this, mapper);
    }

    default public Scanner<RetainingGroup<T>> retain(int retaining) {
        return new RetainingScanner(this, retaining);
    }

    default public Scanner<T> sample(long sampleSize, boolean includeLast) {
        return new SamplingScanner(this, sampleSize, includeLast);
    }

    default public Scanner<T> skip(long numToSkip) {
        return ScannerTool.skip(this, numToSkip);
    }

    default public Scanner<Scanner<T>> splitBy(Function<T, ?> mapper) {
        return new SplittingScanner(this, mapper);
    }

    default public boolean allMatch(Predicate<? super T> predicate) {
        return ScannerTool.allMatch(this, predicate);
    }

    default public boolean anyMatch(Predicate<? super T> predicate) {
        return ScannerTool.anyMatch(this, predicate);
    }

    default public long count() {
        return ScannerTool.count(this);
    }

    default public Optional<T> findAny() {
        return this.findFirst();
    }

    default public Optional<T> findFirst() {
        return ScannerTool.findFirst(this);
    }

    default public Optional<T> findLast() {
        return ScannerTool.findLast(this);
    }

    default public Optional<T> findMax(Comparator<? super T> comparator) {
        return ScannerTool.max(this, comparator);
    }

    default public Optional<T> findMin(Comparator<? super T> comparator) {
        return ScannerTool.min(this, comparator);
    }

    default public boolean hasAny() {
        return ScannerTool.hasAny(this);
    }

    default public boolean isEmpty() {
        return ScannerTool.isEmpty(this);
    }

    default public Optional<T> max(Comparator<? super T> comparator) {
        return this.findMax(comparator);
    }

    default public Optional<T> min(Comparator<? super T> comparator) {
        return this.findMin(comparator);
    }

    default public boolean noneMatch(Predicate<? super T> predicate) {
        return ScannerTool.noneMatch(this, predicate);
    }

    default public Optional<T> reduce(BinaryOperator<T> reducer) {
        return ScannerTool.reduce(this, reducer);
    }

    default public T reduce(T seed, BinaryOperator<T> reducer) {
        return ScannerTool.reduce(this, seed, reducer);
    }

    default public <C extends Collection<T>> C collect(Supplier<C> collectionSupplier) {
        return ScannerTool.collect(this, collectionSupplier);
    }

    default public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.stream().collect(collector);
    }

    default public Scanner<T> distinct() {
        return new DistinctScanner(this, Function.identity());
    }

    default public Scanner<T> distinctBy(Function<T, ?> mapper) {
        return new DistinctScanner(this, mapper);
    }

    default public Scanner<T> flush(Consumer<List<T>> consumer) {
        return ScannerTool.flush(this, consumer);
    }

    default public List<T> list() {
        return ScannerTool.list(this);
    }

    default public <R> R listTo(Function<List<T>, R> mapper) {
        return mapper.apply(this.list());
    }

    default public Scanner<T> reverse() {
        return this.listTo(ReverseListScanner::of);
    }

    default public Scanner<T> shuffle() {
        return new ShufflingScanner(this);
    }

    default public Scanner<T> sort() {
        return new NaturalSortingScanner(this);
    }

    default public Scanner<T> sort(Comparator<? super T> comparator) {
        return new SortingScanner<T>(this, comparator);
    }

    default public Scanner<T> sorted() {
        return this.sort();
    }

    default public Scanner<T> sorted(Comparator<? super T> comparator) {
        return this.sort(comparator);
    }

    default public Object[] toArray() {
        return ScannerTool.toArray(this);
    }

    default public Map<T, T> toMap() {
        return this.apply(ScannerToMap.of());
    }

    default public <K> Map<K, T> toMap(Function<T, K> keyFunction) {
        return this.apply(ScannerToMap.of(keyFunction));
    }

    default public <K, V> Map<K, V> toMap(Function<T, K> keyFunction, Function<T, V> valueFunction) {
        return this.apply(ScannerToMap.of(keyFunction, valueFunction));
    }

    default public <K, V> Map<K, V> toMap(Function<T, K> keyFunction, Function<T, V> valueFunction, ScannerToMap.Replace replacePolicy) {
        return this.apply(ScannerToMap.of(keyFunction, valueFunction, replacePolicy));
    }

    default public <K, V> Map<K, V> toMap(Function<T, K> keyFunction, Function<T, V> valueFunction, BinaryOperator<V> mergeFunction) {
        return this.apply(ScannerToMap.of(keyFunction, valueFunction, mergeFunction));
    }

    default public <K, M extends Map<K, T>> M toMapSupplied(Function<T, K> keyFunction, Supplier<M> mapSupplier) {
        return (M)((Map)this.apply(ScannerToMap.ofSupplied(keyFunction, mapSupplier)));
    }

    default public <K, V, M extends Map<K, V>> M toMapSupplied(Function<T, K> keyFunction, Function<T, V> valueFunction, Supplier<M> mapSupplier) {
        return (M)((Map)this.apply(ScannerToMap.ofSupplied(keyFunction, valueFunction, mapSupplier)));
    }

    default public <K, V, M extends Map<K, V>> M toMapSupplied(Function<T, K> keyFunction, Function<T, V> valueFunction, ScannerToMap.Replace replacePolicy, Supplier<M> mapSupplier) {
        return (M)((Map)this.apply(ScannerToMap.ofSupplied(keyFunction, valueFunction, replacePolicy, mapSupplier)));
    }

    default public <K, V, M extends Map<K, V>> M toMapSupplied(Function<T, K> keyFunction, Function<T, V> valueFunction, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        return (M)((Map)this.apply(ScannerToMap.ofSupplied(keyFunction, valueFunction, mergeFunction, mapSupplier)));
    }

    default public <K> Map<K, List<T>> groupBy(Function<T, K> keyFunction) {
        return this.apply(ScannerToGroups.of(keyFunction));
    }

    default public <K, V> Map<K, List<V>> groupBy(Function<T, K> keyFunction, Function<T, V> valueFunction) {
        return this.apply(ScannerToGroups.of(keyFunction, valueFunction));
    }

    default public <K, V, M extends Map<K, List<V>>> M groupBy(Function<T, K> keyFunction, Function<T, V> valueFunction, Supplier<M> mapSupplier) {
        return (M)((Map)this.apply(ScannerToGroups.of(keyFunction, valueFunction, mapSupplier)));
    }

    default public <K, V, C extends Collection<V>, M extends Map<K, C>> M groupBy(Function<T, K> keyFunction, Function<T, V> valueFunction, Supplier<M> mapSupplier, Supplier<C> collectionSupplier) {
        return (M)((Map)this.apply(ScannerToGroups.of(keyFunction, valueFunction, mapSupplier, collectionSupplier)));
    }

    default public Iterator<T> iterator() {
        return new ScannerIterator(this);
    }

    default public Iterable<T> iterable() {
        return this::iterator;
    }

    default public Stream<T> stream() {
        return new ScannerStream(this);
    }

    default public IntStream streamInts(ToIntFunction<? super T> mapper) {
        return this.stream().mapToInt(mapper);
    }

    default public LongStream streamLongs(ToLongFunction<? super T> mapper) {
        return this.stream().mapToLong(mapper);
    }

    default public DoubleStream streamDoubles(ToDoubleFunction<? super T> mapper) {
        return this.stream().mapToDouble(mapper);
    }
}

