/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.BaseScanner;
import io.datarouter.scanner.Scanner;
import java.util.Objects;
import java.util.function.Function;

public class SplittingScanner<T, R>
extends BaseLinkedScanner<T, Scanner<T>> {
    private final Function<T, R> mapper;
    private boolean outerStarted;
    private boolean foundNext;
    private T nextInnerFirstItem;
    private R currentSplitKey;
    private boolean innerIsActive;

    public SplittingScanner(Scanner<T> input, Function<T, R> mapper) {
        super(input);
        this.mapper = mapper;
        this.outerStarted = false;
        this.foundNext = false;
        this.innerIsActive = false;
    }

    @Override
    protected boolean advanceInternal() {
        if (!this.outerStarted) {
            this.outerStarted = true;
            if (this.input.advance()) {
                this.foundNext = true;
                this.nextInnerFirstItem = this.input.current();
                this.currentSplitKey = this.mapper.apply(this.nextInnerFirstItem);
            } else {
                return false;
            }
        }
        if (this.innerIsActive) {
            while (((Scanner)this.current).advance()) {
            }
        }
        if (this.foundNext) {
            this.current = new InnerScanner();
            return true;
        }
        return false;
    }

    private class InnerScanner
    extends BaseScanner<T> {
        private boolean innerStarted = false;

        private InnerScanner() {
            SplittingScanner.this.innerIsActive = true;
            this.current = SplittingScanner.this.nextInnerFirstItem;
            SplittingScanner.this.foundNext = false;
        }

        @Override
        public boolean advance() {
            if (!this.innerStarted) {
                this.innerStarted = true;
                return true;
            }
            if (SplittingScanner.this.input.advance()) {
                if (Objects.equals(SplittingScanner.this.currentSplitKey, SplittingScanner.this.mapper.apply(SplittingScanner.this.input.current()))) {
                    this.current = SplittingScanner.this.input.current();
                    return true;
                }
                SplittingScanner.this.nextInnerFirstItem = SplittingScanner.this.input.current();
                SplittingScanner.this.currentSplitKey = SplittingScanner.this.mapper.apply(SplittingScanner.this.nextInnerFirstItem);
                SplittingScanner.this.foundNext = true;
            }
            SplittingScanner.this.innerIsActive = false;
            return false;
        }
    }
}

