/**
 * Copyright © 2009 HotPads (admin@hotpads.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.datarouter.scanner;

import java.util.function.Consumer;
import java.util.function.Function;

public class ScannerConsumerFunction<T> implements Function<T,T>{

	private final Consumer<? super T> consumer;

	public ScannerConsumerFunction(Consumer<? super T> consumer){
		this.consumer = consumer;
	}

	@Override
	public T apply(T item){
		consumer.accept(item);
		return item;
	}

}
