/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ScannerTool {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> boolean allMatch(Scanner<T> scanner, Predicate<? super T> predicate) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner<T> $ = scanner;){
            if (scanner.advance()) {
            }
            return true;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> boolean anyMatch(Scanner<T> scanner, Predicate<? super T> predicate) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner<T> $ = scanner;){
            if (scanner.advance()) {
            }
            return false;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public static <T, C extends Collection<T>> C collect(Scanner<T> scanner, Supplier<C> collectionSupplier) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner<T> $ = scanner;){
            Collection collection = (Collection)collectionSupplier.get();
            while (scanner.advance()) {
                collection.add(scanner.current());
            }
            return (C)collection;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> long count(Scanner<T> scanner) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner<T> $ = scanner;){
            long count = 0L;
            while (scanner.advance()) {
                ++count;
            }
            return count;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> Optional<T> findAny(Scanner<T> scanner) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner<T> $ = scanner;){
            if (scanner.advance()) {
                return Optional.of(scanner.current());
            }
            return Optional.empty();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> Optional<T> findFirst(Scanner<T> scanner) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner<T> $ = scanner;){
            if (scanner.advance()) {
                return Optional.of(scanner.current());
            }
            return Optional.empty();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> Optional<T> findLast(Scanner<T> scanner) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner<T> $ = scanner;){
            Object last = null;
            while (scanner.advance()) {
                last = scanner.current();
            }
            return Optional.ofNullable(last);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> Scanner<T> flush(Scanner<T> scanner, Consumer<List<T>> consumer) {
        List<T> list = Collections.unmodifiableList(ScannerTool.list(scanner));
        consumer.accept(list);
        return Scanner.of(list);
    }

    public static <T> void forEach(Scanner<T> scanner, Consumer<? super T> action) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner<T> $ = scanner;){
            while (scanner.advance()) {
                action.accept(scanner.current());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> boolean hasAny(Scanner<T> scanner) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner<T> $ = scanner;){
            return scanner.advance();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> boolean isEmpty(Scanner<T> scanner) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner<T> $ = scanner;){
            boolean bl = !scanner.advance();
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> ArrayList<T> list(Scanner<T> scanner) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner<T> $ = scanner;){
            ArrayList<T> list = new ArrayList<T>();
            while (scanner.advance()) {
                list.add(scanner.current());
            }
            return list;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> Optional<T> max(Scanner<T> scanner, Comparator<? super T> comparator) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner<T> $ = scanner;){
            Object max = null;
            while (scanner.advance()) {
                T current = scanner.current();
                if (max != null && comparator.compare(current, max) <= 0) continue;
                max = current;
            }
            return Optional.ofNullable(max);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> Optional<T> min(Scanner<T> scanner, Comparator<? super T> comparator) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner<T> $ = scanner;){
            Object min = null;
            while (scanner.advance()) {
                T current = scanner.current();
                if (min != null && comparator.compare(current, min) >= 0) continue;
                min = current;
            }
            return Optional.ofNullable(min);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> Stream<T> nativeStream(Scanner<T> scanner) {
        Spliterator<T> spliterator = ScannerTool.spliterator(scanner);
        Stream<T> stream = StreamSupport.stream(spliterator, false);
        stream.onClose(() -> scanner.close());
        return stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> boolean noneMatch(Scanner<T> scanner, Predicate<? super T> predicate) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner<T> $ = scanner;){
            if (scanner.advance()) {
            }
            return true;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public static <T> Optional<T> reduce(Scanner<T> scanner, BinaryOperator<T> reducer) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner<T> $ = scanner;){
            Object result = null;
            while (scanner.advance()) {
                result = result == null ? scanner.current() : reducer.apply(result, scanner.current());
            }
            return Optional.ofNullable(result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> Scanner<T> skip(Scanner<T> scanner, long numToSkip) {
        long numSkipped = 0L;
        while (numSkipped < numToSkip) {
            if (!scanner.advance()) {
                scanner.close();
                return scanner;
            }
            ++numSkipped;
        }
        return scanner;
    }

    public static <T> Spliterator<T> spliterator(Scanner<T> scanner) {
        return Spliterators.spliteratorUnknownSize(scanner.iterator(), 0);
    }

    public static <T> List<T> take(Scanner<T> scanner, int numToTake) {
        ArrayList<T> items = new ArrayList<T>();
        while (items.size() < numToTake) {
            if (!scanner.advance()) {
                scanner.close();
                return items;
            }
            items.add(scanner.current());
        }
        return items;
    }

    public static Object[] toArray(Scanner<?> scanner) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner<?> ref = scanner;){
            return ScannerTool.list(scanner).toArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

