/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.AdvanceUntilScanner;
import io.datarouter.scanner.AdvanceWhileScanner;
import io.datarouter.scanner.ArrayScanner;
import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.BatchingScanner;
import io.datarouter.scanner.CollatingScanner;
import io.datarouter.scanner.ConcatenatingScanner;
import io.datarouter.scanner.DeduplicatingScanner;
import io.datarouter.scanner.DistinctScanner;
import io.datarouter.scanner.EachScanner;
import io.datarouter.scanner.EmptyScanner;
import io.datarouter.scanner.FilteringScanner;
import io.datarouter.scanner.IterableScanner;
import io.datarouter.scanner.IteratorScanner;
import io.datarouter.scanner.LimitingScanner;
import io.datarouter.scanner.MappingScanner;
import io.datarouter.scanner.NaturalSortingScanner;
import io.datarouter.scanner.ObjectScanner;
import io.datarouter.scanner.ParallelScanner;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.PrefetchingScanner;
import io.datarouter.scanner.RetainingGroup;
import io.datarouter.scanner.RetainingScanner;
import io.datarouter.scanner.SamplingScanner;
import io.datarouter.scanner.ScannerIterator;
import io.datarouter.scanner.ScannerStream;
import io.datarouter.scanner.ScannerTool;
import io.datarouter.scanner.SortingScanner;
import io.datarouter.scanner.StreamScanner;
import java.io.Closeable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public interface Scanner<T>
extends Closeable {
    public boolean advance();

    public T current();

    @Override
    default public void close() {
    }

    default public boolean allMatch(Predicate<? super T> predicate) {
        return ScannerTool.allMatch(this, predicate);
    }

    default public boolean anyMatch(Predicate<? super T> predicate) {
        return ScannerTool.anyMatch(this, predicate);
    }

    default public <C extends Collection<T>> C collect(Supplier<C> collectionSupplier) {
        return ScannerTool.collect(this, collectionSupplier);
    }

    default public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.stream().collect(collector);
    }

    default public long count() {
        return ScannerTool.count(this);
    }

    default public Optional<T> findAny() {
        return ScannerTool.findAny(this);
    }

    default public Optional<T> findFirst() {
        return ScannerTool.findFirst(this);
    }

    default public Optional<T> findLast() {
        return ScannerTool.findLast(this);
    }

    default public Scanner<T> flush(Consumer<List<T>> consumer) {
        return ScannerTool.flush(this, consumer);
    }

    default public void forEach(Consumer<? super T> action) {
        ScannerTool.forEach(this, action);
    }

    default public boolean hasAny() {
        return ScannerTool.hasAny(this);
    }

    default public boolean isEmpty() {
        return ScannerTool.isEmpty(this);
    }

    default public List<T> list() {
        return ScannerTool.list(this);
    }

    default public <R> R listTo(Function<List<T>, R> mapper) {
        return mapper.apply(this.list());
    }

    default public Optional<T> max(Comparator<? super T> comparator) {
        return ScannerTool.max(this, comparator);
    }

    default public Optional<T> min(Comparator<? super T> comparator) {
        return ScannerTool.min(this, comparator);
    }

    default public boolean noneMatch(Predicate<? super T> predicate) {
        return ScannerTool.noneMatch(this, predicate);
    }

    default public Optional<T> reduce(BinaryOperator<T> reducer) {
        return ScannerTool.reduce(this, reducer);
    }

    default public Object[] toArray() {
        return ScannerTool.toArray(this);
    }

    default public Scanner<T> advanceUntil(Predicate<? super T> predicate) {
        return new AdvanceUntilScanner<T>(this, predicate);
    }

    default public Scanner<T> advanceWhile(Predicate<? super T> predicate) {
        return new AdvanceWhileScanner<T>(this, predicate);
    }

    default public Scanner<List<T>> batch(int batchSize) {
        return new BatchingScanner(this, batchSize);
    }

    default public Scanner<T> deduplicate() {
        return new DeduplicatingScanner(this, Function.identity());
    }

    default public Scanner<T> deduplicateBy(Function<T, ?> mapper) {
        return new DeduplicatingScanner(this, mapper);
    }

    default public Scanner<T> distinct() {
        return new DistinctScanner(this, Function.identity());
    }

    default public Scanner<T> distinctBy(Function<T, ?> mapper) {
        return new DistinctScanner(this, mapper);
    }

    default public Scanner<T> each(Consumer<? super T> consumer) {
        return new EachScanner<T>(this, consumer);
    }

    default public Scanner<T> exclude(Predicate<? super T> predicate) {
        return new FilteringScanner<T>(this, predicate.negate());
    }

    default public Scanner<T> include(Predicate<? super T> predicate) {
        return new FilteringScanner<T>(this, predicate);
    }

    default public Scanner<T> limit(long limit) {
        return new LimitingScanner(this, limit);
    }

    default public <R> Scanner<R> link(Function<Scanner<T>, BaseLinkedScanner<T, R>> scannerBuilder) {
        return scannerBuilder.apply(this);
    }

    default public <R> Scanner<R> map(Function<? super T, ? extends R> mapper) {
        return new MappingScanner<T, R>(this, mapper);
    }

    default public Scanner<RetainingGroup<T>> retain(int retaining) {
        return new RetainingScanner(this, retaining);
    }

    default public Scanner<T> prefetch(ExecutorService exec, int batchSize) {
        return new PrefetchingScanner<List>(this, exec, batchSize).concat(Scanner::of);
    }

    default public Scanner<T> sample(long sampleSize, boolean includeLast) {
        return new SamplingScanner(this, sampleSize, includeLast);
    }

    default public Scanner<T> skip(long numToSkip) {
        return ScannerTool.skip(this, numToSkip);
    }

    default public Scanner<T> sorted() {
        return new NaturalSortingScanner(this);
    }

    default public Scanner<T> sorted(Comparator<? super T> comparator) {
        return new SortingScanner<T>(this, comparator);
    }

    default public List<T> take(int numToTake) {
        return ScannerTool.take(this, numToTake);
    }

    default public <R> Scanner<R> collate(Function<? super T, Scanner<R>> mapper) {
        return this.collate(mapper, Comparator.naturalOrder());
    }

    default public <R> Scanner<R> collate(Function<? super T, Scanner<R>> mapper, Comparator<? super R> comparator) {
        List scanners = this.map(mapper).list();
        if (scanners.size() == 1) {
            return scanners.get(0);
        }
        return new CollatingScanner<R>(scanners, comparator);
    }

    default public <R> Scanner<R> concat(Function<? super T, Scanner<R>> mapper) {
        Scanner scanners = this.map(mapper);
        return new ConcatenatingScanner(scanners);
    }

    @SafeVarargs
    public static <T> Scanner<T> concat(Scanner<T> ... scanners) {
        return Scanner.of(scanners).concat(Function.identity());
    }

    default public ParallelScanner<T> parallel(ParallelScannerContext context) {
        return new ParallelScanner(context, this);
    }

    default public Iterator<T> iterator() {
        return new ScannerIterator(this);
    }

    default public Iterable<T> iterable() {
        return this::iterator;
    }

    default public Stream<T> stream() {
        return new ScannerStream(this);
    }

    default public IntStream streamInts(ToIntFunction<? super T> mapper) {
        return this.stream().mapToInt(mapper);
    }

    default public LongStream streamLongs(ToLongFunction<? super T> mapper) {
        return this.stream().mapToLong(mapper);
    }

    default public DoubleStream streamDoubles(ToDoubleFunction<? super T> mapper) {
        return this.stream().mapToDouble(mapper);
    }

    public static <T> Scanner<T> empty() {
        return EmptyScanner.singleton();
    }

    public static <T> Scanner<T> of(T object) {
        return ObjectScanner.of(object);
    }

    @SafeVarargs
    public static <T> Scanner<T> of(T ... array) {
        return ArrayScanner.of(array);
    }

    public static <T> Scanner<T> of(Iterator<T> iterator) {
        return IteratorScanner.of(iterator);
    }

    public static <T> Scanner<T> of(Iterable<T> iterable) {
        return IterableScanner.of(iterable);
    }

    public static <T> Scanner<T> of(Stream<T> stream) {
        return StreamScanner.of(stream);
    }
}

