/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.IteratorScanner;
import io.datarouter.scanner.Scanner;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamScanner<T>
extends IteratorScanner<T> {
    private static final Logger logger = LoggerFactory.getLogger(StreamScanner.class);
    private final Stream<T> stream;
    private boolean closed;

    public StreamScanner(Stream<T> stream) {
        super(stream.iterator());
        this.stream = stream;
        this.closed = false;
    }

    public static <T> Scanner<T> of(Stream<T> stream) {
        return new StreamScanner<T>(stream);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.stream.close();
        }
        catch (Exception e) {
            logger.warn("exception on stream.close", (Throwable)e);
        }
        this.closed = true;
    }
}

